/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.listener;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerJobProperty;
import com.nirima.jenkins.plugins.docker.DockerJobTemplateProperty;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Label;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.QueueListener;
import hudson.model.queue.SubTask;
import java.util.UUID;
import javax.annotation.Nonnull;

@Extension
public class DockerQueueListener
extends QueueListener {
    public void onEnterWaiting(Queue.WaitingItem wi) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = this.getJobTemplate((Queue.Item)wi);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) instanceof DockerCloud) {
            String uuid = UUID.randomUUID().toString();
            DockerTemplate template = jobTemplate.getTemplate().cloneWithLabel(uuid);
            cloud.addJobTemplate(wi.getId(), template);
            wi.addAction((Action)new DockerTemplateLabelAssignmentAction(uuid));
        }
    }

    public void onLeft(Queue.LeftItem li) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = this.getJobTemplate((Queue.Item)li);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) instanceof DockerCloud) {
            cloud.removeJobTemplate(li.getId());
        }
    }

    private DockerJobTemplateProperty getJobTemplate(Queue.Item item) {
        Project project;
        if (item.task instanceof Project && (project = (Project)item.task) != null) {
            DockerJobTemplateProperty p = (DockerJobTemplateProperty)project.getProperty(DockerJobTemplateProperty.class);
            if (p != null) {
                return p;
            }
            DockerJobProperty property = (DockerJobProperty)project.getProperty(DockerJobProperty.class);
            if (property != null) {
                return property.getDockerJobTemplate();
            }
        }
        return null;
    }

    private static class DockerTemplateLabelAssignmentAction
    extends InvisibleAction
    implements LabelAssignmentAction {
        private final String uuid;

        private DockerTemplateLabelAssignmentAction(String uuid) {
            this.uuid = uuid;
        }

        public Label getAssignedLabel(@Nonnull SubTask task) {
            return new LabelAtom(this.uuid);
        }
    }
}

