/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class DockerBuildAction
implements Action,
Serializable,
Cloneable,
Describable<DockerBuildAction> {
    private String cloudId;
    private final String containerHost;
    private final String containerId;
    private String inspect;
    private String taggedId;

    public DockerBuildAction(String containerHost, String containerId, String taggedId) {
        this.containerHost = containerHost;
        this.containerId = containerId;
        this.taggedId = taggedId;
    }

    public DockerBuildAction(DockerTransientNode node) {
        DockerAPI dockerAPI = node.getDockerAPI();
        this.containerHost = dockerAPI.getDockerHost().getUri();
        this.containerId = node.getContainerId();
        this.cloudId = node.getCloudId();
        try {
            InspectContainerResponse containerDetails;
            try (DockerClient client = dockerAPI.getClient();){
                containerDetails = client.inspectContainerCmd(this.containerId).exec();
            }
            this.inspect = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)containerDetails);
        }
        catch (IOException e) {
            this.inspect = "Failed to capture container inspection data: " + e.getMessage();
        }
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public String getContainerHost() {
        return this.containerHost;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getTaggedId() {
        return this.taggedId;
    }

    public String getInspect() {
        return this.inspect;
    }

    public String getIconFileName() {
        return "/plugin/docker-plugin/images/24x24/docker.png";
    }

    public String getDisplayName() {
        return "Built on Docker";
    }

    public String getUrlName() {
        return "docker";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerBuildAction> {
        public String getDisplayName() {
            return "Docker";
        }
    }
}

