/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.NameParser;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.plugins.docker.DockerContainerLabelKeys;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerTemplateBase
implements Describable<DockerTemplateBase>,
Serializable {
    private final String image;
    private String pullCredentialsId;
    private transient DockerRegistryEndpoint registry;
    private String dockerCommand;
    public String hostname;
    public String[] dnsHosts;
    public String network;
    public String[] volumes;
    @Deprecated
    public String volumesFrom;
    public String[] volumesFrom2;
    public String[] devices;
    @CheckForNull
    public String[] environment;
    public String bindPorts;
    public boolean bindAllPorts;
    public Integer memoryLimit;
    public Integer memorySwap;
    public Integer cpuShares;
    public Integer shmSize;
    public boolean privileged;
    public boolean tty;
    @CheckForNull
    private String macAddress;
    @CheckForNull
    private List<String> extraHosts;

    @DataBoundConstructor
    public DockerTemplateBase(String image) {
        if (image == null) {
            throw new IllegalArgumentException("Image can't be null");
        }
        this.image = image.trim();
    }

    @Deprecated
    public DockerTemplateBase(String image, String pullCredentialsId, String dnsString, String network, String dockerCommand, String volumesString, String volumesFromString, String environmentsString, String hostname, Integer memoryLimit, Integer memorySwap, Integer cpuShares, Integer shmSize, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress, String extraHostsString) {
        this(image);
        this.setPullCredentialsId(pullCredentialsId);
        this.setDnsString(dnsString);
        this.setNetwork(network);
        this.setDockerCommand(dockerCommand);
        this.setVolumesString(volumesString);
        this.setVolumesFromString(volumesFromString);
        this.setEnvironmentsString(environmentsString);
        this.setHostname(hostname);
        this.setMemoryLimit(memoryLimit);
        this.setMemorySwap(memorySwap);
        this.setCpuShares(cpuShares);
        this.setShmSize(shmSize);
        this.setBindPorts(bindPorts);
        this.setBindAllPorts(bindAllPorts);
        this.setPrivileged(privileged);
        this.setTty(tty);
        this.setMacAddress(macAddress);
        this.setExtraHostsString(extraHostsString);
    }

    protected Object readResolve() {
        if (this.volumesFrom != null) {
            if (StringUtils.isNotBlank((String)this.volumesFrom)) {
                this.setVolumesFrom2(new String[]{this.volumesFrom});
            }
            this.volumesFrom = null;
        }
        if (this.pullCredentialsId == null && this.registry != null) {
            this.pullCredentialsId = this.registry.getCredentialsId();
        }
        return this;
    }

    public static String[] splitAndFilterEmpty(String s, String separator) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String o : Splitter.on((String)separator).omitEmptyStrings().split((CharSequence)s)) {
            result.add(o);
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<String> splitAndFilterEmptyList(String s, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String o : Splitter.on((String)separator).omitEmptyStrings().split((CharSequence)s)) {
            result.add(o);
        }
        return result;
    }

    public static String[] filterStringArray(String[] arr) {
        ArrayList<String> strings = new ArrayList<String>();
        if (arr != null) {
            for (String s : arr) {
                if ((s = StringUtils.stripToNull((String)s)) == null) continue;
                strings.add(s);
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public String getImage() {
        return this.image.trim();
    }

    public String getPullCredentialsId() {
        return this.pullCredentialsId;
    }

    @DataBoundSetter
    public void setPullCredentialsId(String pullCredentialsId) {
        this.pullCredentialsId = pullCredentialsId;
    }

    public String getDockerCommand() {
        return this.dockerCommand;
    }

    @DataBoundSetter
    public void setDockerCommand(String dockerCommand) {
        this.dockerCommand = dockerCommand;
    }

    public String getHostname() {
        return this.hostname;
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getDnsString() {
        if (this.dnsHosts == null) {
            return null;
        }
        return Joiner.on((String)" ").join((Object[])this.dnsHosts);
    }

    @DataBoundSetter
    public void setDnsString(String dnsString) {
        this.dnsHosts = DockerTemplateBase.splitAndFilterEmpty(dnsString, " ");
    }

    public String getNetwork() {
        return this.network;
    }

    @DataBoundSetter
    public void setNetwork(String network) {
        this.network = network;
    }

    @CheckForNull
    public String[] getVolumes() {
        return DockerTemplateBase.filterStringArray(this.volumes);
    }

    public void setVolumes(String[] volumes) {
        this.volumes = volumes;
    }

    public String getVolumesString() {
        if (this.volumes == null) {
            return null;
        }
        return Joiner.on((String)"\n").join((Object[])this.volumes);
    }

    @DataBoundSetter
    public void setVolumesString(String volumesString) {
        this.volumes = DockerTemplateBase.splitAndFilterEmpty(volumesString, "\n");
    }

    public String getVolumesFromString() {
        return Joiner.on((String)"\n").join((Object[])this.getVolumesFrom2());
    }

    @DataBoundSetter
    public void setVolumesFromString(String volumesFromString) {
        this.setVolumesFrom2(DockerTemplateBase.splitAndFilterEmpty(volumesFromString, "\n"));
    }

    @CheckForNull
    public String[] getDevices() {
        return DockerTemplateBase.filterStringArray(this.devices);
    }

    public String getDevicesString() {
        if (this.devices == null) {
            return null;
        }
        return Joiner.on((String)"\n").join((Object[])this.devices);
    }

    @DataBoundSetter
    public void setDevicesString(String devicesString) {
        this.devices = DockerTemplateBase.splitAndFilterEmpty(devicesString, "\n");
    }

    public String getEnvironmentsString() {
        if (this.environment == null) {
            return null;
        }
        return Joiner.on((String)"\n").join((Object[])this.environment);
    }

    @DataBoundSetter
    public void setEnvironmentsString(String environmentsString) {
        this.environment = DockerTemplateBase.splitAndFilterEmpty(environmentsString, "\n");
    }

    public String getBindPorts() {
        return this.bindPorts;
    }

    @DataBoundSetter
    public void setBindPorts(String bindPorts) {
        this.bindPorts = bindPorts;
    }

    public boolean isBindAllPorts() {
        return this.bindAllPorts;
    }

    @DataBoundSetter
    public void setBindAllPorts(boolean bindAllPorts) {
        this.bindAllPorts = bindAllPorts;
    }

    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @DataBoundSetter
    public void setMemoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public Integer getMemorySwap() {
        return this.memorySwap;
    }

    @DataBoundSetter
    public void setMemorySwap(Integer memorySwap) {
        this.memorySwap = memorySwap;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    @DataBoundSetter
    public void setCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
    }

    public Integer getShmSize() {
        return this.shmSize;
    }

    @DataBoundSetter
    public void setShmSize(Integer shmSize) {
        this.shmSize = shmSize;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean isTty() {
        return this.tty;
    }

    @DataBoundSetter
    public void setTty(boolean tty) {
        this.tty = tty;
    }

    @CheckForNull
    public String getMacAddress() {
        return StringUtils.trimToNull((String)this.macAddress);
    }

    @DataBoundSetter
    public void setMacAddress(String macAddress) {
        this.macAddress = StringUtils.trimToNull((String)macAddress);
    }

    @DataBoundSetter
    public void setExtraHostsString(String extraHostsString) {
        this.setExtraHosts(StringUtils.isEmpty((String)extraHostsString) ? Collections.EMPTY_LIST : DockerTemplateBase.splitAndFilterEmptyList(extraHostsString, "\n"));
    }

    public String getExtraHostsString() {
        if (this.extraHosts == null) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.extraHosts);
    }

    public DockerRegistryEndpoint getRegistry() {
        if (this.registry == null) {
            this.registry = new DockerRegistryEndpoint(null, this.pullCredentialsId);
        }
        return this.registry;
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    public String[] getVolumesFrom2() {
        return DockerTemplateBase.filterStringArray(this.volumesFrom2);
    }

    public void setVolumesFrom2(String[] volumes) {
        this.volumesFrom2 = volumes;
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public void setExtraHosts(List<String> extraHosts) {
        this.extraHosts = extraHosts;
    }

    public String getDisplayName() {
        return "Image of " + this.getImage();
    }

    public String[] getDockerCommandArray() {
        String[] dockerCommandArray = new String[]{};
        if (this.dockerCommand != null && !this.dockerCommand.isEmpty()) {
            dockerCommandArray = this.dockerCommand.split(" ");
        }
        return dockerCommandArray;
    }

    public Iterable<PortBinding> getPortMappings() {
        if (Strings.isNullOrEmpty((String)this.bindPorts)) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Splitter.on((char)' ').trimResults().omitEmptyStrings().split((CharSequence)this.bindPorts), (Function)new Function<String, PortBinding>(){

            @Nullable
            public PortBinding apply(String s) {
                return PortBinding.parse((String)s);
            }
        });
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        List<String> extraHosts;
        String[] cmd;
        if (this.hostname != null && !this.hostname.isEmpty()) {
            containerConfig.withHostName(this.hostname);
        }
        if ((cmd = this.getDockerCommandArray()).length > 0) {
            containerConfig.withCmd(cmd);
        }
        containerConfig.withPortBindings((PortBinding[])Iterables.toArray(this.getPortMappings(), PortBinding.class));
        containerConfig.withPublishAllPorts(Boolean.valueOf(this.bindAllPorts));
        containerConfig.withPrivileged(Boolean.valueOf(this.privileged));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DockerContainerLabelKeys.JENKINS_INSTANCE_ID, DockerTemplateBase.getJenkinsInstanceIdForContainerLabel());
        map.put(DockerContainerLabelKeys.JENKINS_URL, DockerTemplateBase.getJenkinsUrlForContainerLabel());
        map.put(DockerContainerLabelKeys.CONTAINER_IMAGE, this.getImage());
        containerConfig.withLabels(map);
        if (this.cpuShares != null && this.cpuShares > 0) {
            containerConfig.withCpuShares(this.cpuShares);
        }
        if (this.memoryLimit != null && this.memoryLimit > 0) {
            Long memoryInByte = (long)this.memoryLimit.intValue() * 1024L * 1024L;
            containerConfig.withMemory(memoryInByte);
        }
        if (this.memorySwap != null) {
            if (this.memorySwap > 0) {
                Long memorySwapInByte = (long)this.memorySwap.intValue() * 1024L * 1024L;
                containerConfig.withMemorySwap(memorySwapInByte);
            } else {
                containerConfig.withMemorySwap(Long.valueOf(this.memorySwap.longValue()));
            }
        }
        if (this.dnsHosts != null && this.dnsHosts.length > 0) {
            containerConfig.withDns(this.dnsHosts);
        }
        if (this.network != null && this.network.length() > 0) {
            containerConfig.withNetworkDisabled(Boolean.valueOf(false));
            containerConfig.withNetworkMode(this.network);
        }
        if (this.getVolumes().length > 0) {
            ArrayList<Volume> vols = new ArrayList<Volume>();
            String[] binds = new ArrayList();
            String[] stringArray = this.getVolumes();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String vol = stringArray[i];
                String[] group = vol.split(":");
                if (group.length > 1) {
                    if (group[1].equals("/")) {
                        throw new IllegalArgumentException("Invalid bind mount: destination can't be '/'");
                    }
                    binds.add(Bind.parse((String)vol));
                    continue;
                }
                if (vol.equals("/")) {
                    throw new IllegalArgumentException("Invalid volume: path can't be '/'");
                }
                vols.add(new Volume(vol));
            }
            containerConfig.withVolumes(vols.toArray(new Volume[vols.size()]));
            containerConfig.withBinds(binds.toArray(new Bind[binds.size()]));
        }
        if (this.getVolumesFrom2().length > 0) {
            ArrayList<VolumesFrom> volFrom = new ArrayList<VolumesFrom>();
            for (String volFromStr : this.getVolumesFrom2()) {
                volFrom.add(new VolumesFrom(volFromStr));
            }
            containerConfig.withVolumesFrom(volFrom.toArray(new VolumesFrom[volFrom.size()]));
        }
        if (this.getDevices().length > 0) {
            ArrayList<Device> devices = new ArrayList<Device>();
            for (String deviceStr : this.getDevices()) {
                devices.add(Device.parse((String)deviceStr));
            }
            containerConfig.withDevices(devices);
        }
        containerConfig.withTty(Boolean.valueOf(this.tty));
        if (this.environment != null && this.environment.length > 0) {
            containerConfig.withEnv(this.environment);
        }
        if (this.getMacAddress() != null) {
            containerConfig.withMacAddress(this.getMacAddress());
        }
        if (CollectionUtils.isNotEmpty(extraHosts = this.getExtraHosts())) {
            containerConfig.withExtraHosts(extraHosts.toArray(new String[extraHosts.size()]));
        }
        if (this.shmSize != null && this.shmSize > 0) {
            Long shmSizeInByte = (long)this.shmSize.intValue() * 1024L * 1024L;
            containerConfig.getHostConfig().withShmSize(shmSizeInByte);
        }
        return containerConfig;
    }

    static String getJenkinsUrlForContainerLabel() {
        Jenkins jenkins = Jenkins.getInstance();
        String rootUrl = jenkins == null ? null : jenkins.getRootUrl();
        return Util.fixNull((String)rootUrl);
    }

    static String getJenkinsInstanceIdForContainerLabel() {
        return JenkinsUtils.getInstanceId();
    }

    public Descriptor<DockerTemplateBase> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(DockerTemplateBase.class);
    }

    public String getFullImageId() {
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)this.image);
        return repostag.repos + ":" + (repostag.tag.isEmpty() ? "latest" : repostag.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DockerTemplateBase{");
        sb.append("image='").append(this.image).append('\'');
        sb.append(", pullCredentialsId='").append(this.pullCredentialsId).append('\'');
        sb.append(", registry=").append(this.registry);
        sb.append(", dockerCommand='").append(this.dockerCommand).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", dnsHosts=").append(Arrays.toString(this.dnsHosts));
        sb.append(", network='").append(this.network).append('\'');
        sb.append(", volumes=").append(Arrays.toString(this.volumes));
        sb.append(", volumesFrom2=").append(Arrays.toString(this.volumesFrom2));
        sb.append(", environment=").append(Arrays.toString(this.environment));
        sb.append(", bindPorts='").append(this.bindPorts).append('\'');
        sb.append(", bindAllPorts=").append(this.bindAllPorts);
        sb.append(", memoryLimit=").append(this.memoryLimit);
        sb.append(", memorySwap=").append(this.memorySwap);
        sb.append(", cpuShares=").append(this.cpuShares);
        sb.append(", shmSize=").append(this.shmSize);
        sb.append(", privileged=").append(this.privileged);
        sb.append(", tty=").append(this.tty);
        sb.append(", macAddress='").append(this.macAddress).append('\'');
        sb.append(", extraHosts=").append(this.extraHosts);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerTemplateBase that = (DockerTemplateBase)o;
        if (this.bindAllPorts != that.bindAllPorts) {
            return false;
        }
        if (this.privileged != that.privileged) {
            return false;
        }
        if (this.tty != that.tty) {
            return false;
        }
        if (!this.image.equals(that.image)) {
            return false;
        }
        if (this.pullCredentialsId != null ? !this.pullCredentialsId.equals(that.pullCredentialsId) : that.pullCredentialsId != null) {
            return false;
        }
        if (this.registry != null ? !this.registry.equals((Object)that.registry) : that.registry != null) {
            return false;
        }
        if (this.dockerCommand != null ? !this.dockerCommand.equals(that.dockerCommand) : that.dockerCommand != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (!Arrays.equals(this.dnsHosts, that.dnsHosts)) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (!Arrays.equals(this.volumes, that.volumes)) {
            return false;
        }
        if (!Arrays.equals(this.volumesFrom2, that.volumesFrom2)) {
            return false;
        }
        if (!Arrays.equals(this.environment, that.environment)) {
            return false;
        }
        if (this.bindPorts != null ? !this.bindPorts.equals(that.bindPorts) : that.bindPorts != null) {
            return false;
        }
        if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) {
            return false;
        }
        if (this.memorySwap != null ? !this.memorySwap.equals(that.memorySwap) : that.memorySwap != null) {
            return false;
        }
        if (this.cpuShares != null ? !this.cpuShares.equals(that.cpuShares) : that.cpuShares != null) {
            return false;
        }
        if (this.shmSize != null ? !this.shmSize.equals(that.shmSize) : that.shmSize != null) {
            return false;
        }
        if (this.macAddress != null ? !this.macAddress.equals(that.macAddress) : that.macAddress != null) {
            return false;
        }
        return this.extraHosts != null ? this.extraHosts.equals(that.extraHosts) : that.extraHosts == null;
    }

    public int hashCode() {
        int result = this.image.hashCode();
        result = 31 * result + (this.pullCredentialsId != null ? this.pullCredentialsId.hashCode() : 0);
        result = 31 * result + (this.registry != null ? this.registry.hashCode() : 0);
        result = 31 * result + (this.dockerCommand != null ? this.dockerCommand.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.dnsHosts);
        result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.volumes);
        result = 31 * result + Arrays.hashCode(this.volumesFrom2);
        result = 31 * result + Arrays.hashCode(this.environment);
        result = 31 * result + (this.bindPorts != null ? this.bindPorts.hashCode() : 0);
        result = 31 * result + (this.bindAllPorts ? 1 : 0);
        result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
        result = 31 * result + (this.memorySwap != null ? this.memorySwap.hashCode() : 0);
        result = 31 * result + (this.cpuShares != null ? this.cpuShares.hashCode() : 0);
        result = 31 * result + (this.shmSize != null ? this.shmSize.hashCode() : 0);
        result = 31 * result + (this.privileged ? 1 : 0);
        result = 31 * result + (this.tty ? 1 : 0);
        result = 31 * result + (this.macAddress != null ? this.macAddress.hashCode() : 0);
        result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerTemplateBase> {
        public FormValidation doCheckVolumesString(@QueryParameter String volumesString) {
            try {
                String[] strings;
                for (String s : strings = DockerTemplateBase.splitAndFilterEmpty(volumesString, "\n")) {
                    if (s.equals("/")) {
                        return FormValidation.error((String)"Invalid volume: path can't be '/'");
                    }
                    String[] group = s.split(":");
                    if (group.length > 3) {
                        return FormValidation.error((String)("Wrong syntax: " + s));
                    }
                    if (group.length == 2 || group.length == 3) {
                        if (group[1].equals("/")) {
                            return FormValidation.error((String)"Invalid bind mount: destination can't be '/'");
                        }
                        Bind.parse((String)s);
                        continue;
                    }
                    if (group.length == 1) {
                        new Volume(s);
                        continue;
                    }
                    return FormValidation.error((String)("Wrong line: " + s));
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVolumesFromString(@QueryParameter String volumesFromString) {
            try {
                String[] strings;
                for (String volFrom : strings = DockerTemplateBase.splitAndFilterEmpty(volumesFromString, "\n")) {
                    VolumesFrom.parse((String)volFrom);
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraHostsString(@QueryParameter String extraHostsString) {
            List<String> extraHosts = DockerTemplateBase.splitAndFilterEmptyList(extraHostsString, "\n");
            for (String extraHost : extraHosts) {
                if (extraHost.trim().split(":").length >= 2) continue;
                return FormValidation.error((String)"Wrong extraHost {}", (Object[])new Object[]{extraHost});
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPullCredentialsIdItems(@AncestorInPath Item item) {
            DockerRegistryEndpoint.DescriptorImpl descriptor = (DockerRegistryEndpoint.DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(DockerRegistryEndpoint.class);
            return descriptor.doFillCredentialsIdItems(item);
        }

        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            Jenkins ac;
            Object object = ac = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (!ac.hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }

        public String getDisplayName() {
            return "Docker template base";
        }
    }
}

