/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagement;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DockerManagementServer
implements Describable<DockerManagementServer> {
    final String name;
    final DockerCloud theCloud;

    public Descriptor<DockerManagementServer> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String getUrl() {
        return DockerManagement.get().getUrlName() + "/server/" + this.name;
    }

    public DockerManagementServer(String name) {
        this.name = name;
        this.theCloud = JenkinsUtils.getServer(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getImages() {
        DockerAPI dockerApi = this.theCloud.getDockerApi();
        try (DockerClient client = dockerApi.getClient();){
            Collection collection = (Collection)client.listImagesCmd().exec();
            return collection;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getProcesses() {
        DockerAPI dockerApi = this.theCloud.getDockerApi();
        try (DockerClient client = dockerApi.getClient();){
            Collection collection = (Collection)client.listContainersCmd().exec();
            return collection;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String asTime(Long time) {
        if (time == null) {
            return "";
        }
        long when = System.currentTimeMillis() - time;
        Date dt = new Date(when);
        return dt.toString();
    }

    public String getJsUrl(String jsName) {
        return "/plugin/docker-plugin/js/" + jsName;
    }

    public void doControlSubmit(@QueryParameter(value="stopId") String stopId, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        DockerAPI dockerApi = this.theCloud.getDockerApi();
        try (DockerClient client = dockerApi.getClient();){
            client.stopContainerCmd(stopId).exec();
        }
        rsp.sendRedirect(".");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagementServer> {
        public String getDisplayName() {
            return "server ";
        }
    }
}

