/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.Messages;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerDisabled
extends AbstractDescribableImpl<DockerDisabled>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean disabledByChoice;
    private transient boolean disabledBySystem;
    private transient long nanotimeWhenDisabledBySystem;
    private transient long nanotimeWhenReEnableBySystem;
    private transient String reasonWhyDisabledBySystem;
    private transient Throwable exceptionWhenDisabledBySystem;

    @DataBoundConstructor
    public DockerDisabled() {
    }

    @DataBoundSetter
    public void setDisabledByChoice(boolean disabledByChoice) {
        this.disabledByChoice = disabledByChoice;
    }

    public boolean getDisabledByChoice() {
        return this.disabledByChoice;
    }

    @Restricted(value={NoExternalUse.class})
    public void disableBySystem(@Nonnull String reasonGiven, long durationInMilliseconds, @Nullable Throwable exception) {
        long durationInNanoseconds = TimeUnit.MILLISECONDS.toNanos(durationInMilliseconds);
        long now = this.readTimeNowInNanoseconds();
        this.disabledBySystem = true;
        this.nanotimeWhenDisabledBySystem = now;
        this.nanotimeWhenReEnableBySystem = now + durationInNanoseconds;
        this.reasonWhyDisabledBySystem = reasonGiven;
        this.exceptionWhenDisabledBySystem = exception;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDisabled() {
        return this.getDisabledByChoice() || this.getDisabledBySystem();
    }

    @DataBoundSetter
    public void setEnabledByChoice(boolean enabledByChoice) {
        this.setDisabledByChoice(!enabledByChoice);
    }

    public boolean getEnabledByChoice() {
        return !this.getDisabledByChoice();
    }

    public boolean getDisabledBySystem() {
        if (this.disabledBySystem) {
            long now = this.readTimeNowInNanoseconds();
            long disabledTimeRemaining = this.nanotimeWhenReEnableBySystem - now;
            if (disabledTimeRemaining > 0L) {
                return true;
            }
            this.disabledBySystem = false;
            this.nanotimeWhenDisabledBySystem = 0L;
            this.nanotimeWhenReEnableBySystem = 0L;
            this.reasonWhyDisabledBySystem = null;
            this.exceptionWhenDisabledBySystem = null;
        }
        return false;
    }

    public String getWhenDisabledBySystemString() {
        if (!this.getDisabledBySystem()) {
            return "";
        }
        long now = this.readTimeNowInNanoseconds();
        long howLongAgoInNanoseconds = now - this.nanotimeWhenDisabledBySystem;
        long howLongAgoInMilliseconds = TimeUnit.NANOSECONDS.toMillis(howLongAgoInNanoseconds);
        return Util.getPastTimeString((long)howLongAgoInMilliseconds);
    }

    public String getWhenReEnableBySystemString() {
        long now = this.readTimeNowInNanoseconds();
        if (!this.getDisabledBySystem()) {
            return "";
        }
        long howSoonInNanoseconds = this.nanotimeWhenReEnableBySystem - now;
        long howSoonInMilliseconds = TimeUnit.NANOSECONDS.toMillis(howSoonInNanoseconds);
        return Util.getTimeSpanString((long)howSoonInMilliseconds);
    }

    public String getReasonWhyDisabledBySystem() {
        if (!this.getDisabledBySystem()) {
            return "";
        }
        return this.reasonWhyDisabledBySystem;
    }

    public String getExceptionWhenDisabledBySystemString() {
        if (!this.getDisabledBySystem() || this.exceptionWhenDisabledBySystem == null) {
            return "";
        }
        return Functions.printThrowable((Throwable)this.exceptionWhenDisabledBySystem);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerDisabled other = (DockerDisabled)o;
        return this.disabledByChoice == other.disabledByChoice;
    }

    public int hashCode() {
        int result = this.disabledByChoice ? 1 : 0;
        return result;
    }

    public String toString() {
        boolean ByChoice = this.getDisabledByChoice();
        boolean bySystem = this.getDisabledBySystem();
        if (bySystem) {
            String ago = this.getWhenDisabledBySystemString();
            String until = this.getWhenReEnableBySystemString();
            String why = this.getReasonWhyDisabledBySystem();
            if (ByChoice) {
                return "ByChoice,BySystem," + ago + "," + until + "," + why;
            }
            return "BySystem," + ago + "," + until + "," + why;
        }
        if (ByChoice) {
            return "ByChoice";
        }
        return "No";
    }

    @Restricted(value={NoExternalUse.class})
    protected long readTimeNowInNanoseconds() {
        return System.nanoTime();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerDisabled> {
        public FormValidation doCheckEnabledByChoice(@QueryParameter boolean enabledByChoice, @QueryParameter boolean disabledBySystem, @QueryParameter String whenDisabledBySystemString, @QueryParameter String whenReEnableBySystemString, @QueryParameter String reasonWhyDisabledBySystem, @QueryParameter String exceptionWhenDisabledBySystemString) {
            if (!enabledByChoice) {
                return FormValidation.warning((String)"Note: Disabled.");
            }
            if (disabledBySystem) {
                String reason = Util.fixNull((String)reasonWhyDisabledBySystem);
                String disabledAgo = Util.fixNull((String)whenDisabledBySystemString);
                String enableWhen = Util.fixNull((String)whenReEnableBySystemString);
                String exception = Util.fixNull((String)exceptionWhenDisabledBySystemString);
                if (!(reason.isEmpty() || disabledAgo.isEmpty() || enableWhen.isEmpty())) {
                    StringBuilder html = new StringBuilder();
                    html.append("Note: Disabled ");
                    html.append(Util.escape((String)disabledAgo));
                    html.append(" ago due to error.");
                    html.append("  Will re-enable in ");
                    html.append(Util.escape((String)enableWhen));
                    html.append(".");
                    html.append("<br/>Reason: ");
                    html.append(Util.escape((String)reason));
                    if (!exception.isEmpty()) {
                        html.append(" <a href='#' class='showDetails'>");
                        html.append(Messages.ShowDetails());
                        html.append("</a><pre style='display:none'>");
                        html.append(Util.escape((String)exception));
                        html.append("</pre>");
                    }
                    return FormValidation.warningWithMarkup((String)html.toString());
                }
            }
            return FormValidation.ok();
        }
    }
}

