/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc;

import io.jenkins.plugins.casc.misc.Env;
import io.jenkins.plugins.casc.misc.Envs;
import io.jenkins.plugins.casc.misc.EnvsFromFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EnvVarsRule
extends EnvironmentVariables {
    private Class<?> clazz;

    private void setValue(Env env) {
        String value = env.value();
        if (env.name().endsWith("FILE_PATH")) {
            value = new File(this.clazz.getResource(value).getPath()).getAbsolutePath();
        }
        this.set(env.name(), value);
    }

    public Statement apply(Statement base, Description description) {
        Envs configuredWithEnvs;
        EnvsFromFile configuredWithEnvsFromFile = (EnvsFromFile)description.getAnnotation(EnvsFromFile.class);
        this.clazz = description.getTestClass();
        if (Objects.nonNull(configuredWithEnvsFromFile)) {
            String[] resource = configuredWithEnvsFromFile.value();
            List envFiles = Arrays.stream(resource).map(s -> Paths.get(System.getProperty("java.io.tmpdir"), s).toString()).collect(Collectors.toList());
            Properties properties = new Properties();
            for (String file : envFiles) {
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        properties.load(inputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.set(String.valueOf(key), String.valueOf(value))));
        }
        if (Objects.nonNull(configuredWithEnvs = (Envs)description.getAnnotation(Envs.class))) {
            List<Env> envs = Arrays.asList(configuredWithEnvs.value());
            envs.forEach(this::setValue);
        }
        return super.apply(base, description);
    }
}

