/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.Configurable;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;

public class ConfigurableConfigurator<T extends Configurable>
implements Configurator<T> {
    private final Class<T> target;

    public ConfigurableConfigurator(Class<T> target) {
        this.target = target;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    @NonNull
    public Set<Attribute<T, ?>> describe() {
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public T configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.configure(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + String.valueOf(this.target) + " with default constructor", e);
        }
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.check(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + String.valueOf(this.target) + " with default constructor", e);
        }
    }

    @Override
    @CheckForNull
    public CNode describe(T instance, ConfigurationContext context) throws Exception {
        return instance.describe();
    }
}

