/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;

public interface Configurator<T> {
    @NonNull
    public static String normalize(@NonNull String name) {
        String result = name;
        result = result.toUpperCase().equals(name) ? result.toLowerCase() : StringUtils.uncapitalize((String)name);
        return result;
    }

    @NonNull
    default public String getName() {
        return this.getNames().get(0);
    }

    @NonNull
    default public List<String> getNames() {
        Symbol annotation = this.getTarget().getAnnotation(Symbol.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        return Collections.singletonList(Configurator.normalize(this.getTarget().getSimpleName()));
    }

    default public String getDisplayName() {
        return this.getName();
    }

    public Class<T> getTarget();

    default public boolean canConfigure(Class clazz) {
        return clazz == this.getTarget();
    }

    @NonNull
    default public Class getImplementedAPI() {
        return this.getTarget();
    }

    @NonNull
    default public List<Configurator<T>> getConfigurators(ConfigurationContext context) {
        return Collections.singletonList(this);
    }

    @NonNull
    public Set<Attribute<T, ?>> describe();

    @NonNull
    default public List<Attribute<T, ?>> getAttributes() {
        return this.describe().stream().filter(a -> !a.isIgnored()).sorted(Comparator.comparing(a -> a.name)).collect(Collectors.toList());
    }

    @NonNull
    public T configure(CNode var1, ConfigurationContext var2) throws ConfiguratorException;

    public T check(CNode var1, ConfigurationContext var2) throws ConfiguratorException;

    @CheckForNull
    default public CNode describe(T instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute<T, ?> attribute : this.getAttributes()) {
            CNode value = attribute.describe(instance, context);
            if (value == null) continue;
            mapping.put(attribute.getName(), value);
        }
        return mapping;
    }

    @CheckForNull
    default public CNode describeStructure(T instance, ConfigurationContext context) {
        Mapping mapping = new Mapping();
        for (Attribute<T, ?> attribute : this.getAttributes()) {
            CNode value;
            if (context.getMode().equals("JSONSchema")) {
                attribute.setJsonSchema(true);
            }
            if ((value = attribute.describeForSchema(instance, context)) == null) continue;
            mapping.put(attribute.getName(), attribute.getType().getSimpleName());
        }
        return mapping;
    }

    public static double extractExtensionOrdinal(Object obj) {
        if (obj instanceof Attribute) {
            return Configurator.extractExtensionOrdinal((Attribute)obj);
        }
        return Configurator.extractExtensionOrdinal(obj.getClass());
    }

    public static double extractExtensionOrdinal(Attribute<?, ?> attribute) {
        return Configurator.extractExtensionOrdinal(attribute.type);
    }

    public static double extractExtensionOrdinal(Class clazz) {
        Extension extension = clazz.getAnnotation(Extension.class);
        if (extension == null) {
            return 0.0;
        }
        return extension.ordinal();
    }

    public static Comparator<Object> extensionOrdinalSort() {
        return Comparator.comparingDouble(Configurator::extractExtensionOrdinal).reversed();
    }
}

