/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.casc.Configurator;
import java.util.Collections;
import java.util.List;

public class ConfiguratorException
extends RuntimeException {
    @CheckForNull
    private final Configurator configurator;
    private final List<String> validAttributes;
    @CheckForNull
    private final String invalidAttribute;

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, String invalidAttribute, List<String> validAttributes, @CheckForNull Throwable cause) {
        super(message, cause);
        this.configurator = configurator;
        this.invalidAttribute = invalidAttribute;
        this.validAttributes = validAttributes;
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, @CheckForNull Throwable cause) {
        super(message, cause);
        this.configurator = configurator;
        this.invalidAttribute = null;
        this.validAttributes = Collections.emptyList();
    }

    public ConfiguratorException(@CheckForNull String message, @CheckForNull Throwable cause) {
        this(null, message, null, Collections.emptyList(), cause);
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message) {
        this(configurator, message, null, Collections.emptyList(), null);
    }

    public ConfiguratorException(@CheckForNull String message) {
        this(null, message, null, Collections.emptyList(), null);
    }

    public ConfiguratorException(@CheckForNull Throwable cause) {
        this(null, null, null, Collections.emptyList(), cause);
    }

    @CheckForNull
    public Configurator getConfigurator() {
        return this.configurator;
    }

    public List<String> getValidAttributes() {
        return this.validAttributes;
    }

    public String getInvalidAttribute() {
        return this.invalidAttribute;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.configurator != null) {
            return String.format("%s: %s", this.configurator.getName(), super.getMessage());
        }
        return super.getMessage();
    }
}

