/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import io.jenkins.plugins.casc.model.Sequence;
import io.jenkins.plugins.casc.model.Source;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.lang.ObjectUtils;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

class ModelConstructor
extends CustomClassLoaderConstructor {
    private static final Construct ConstructScalar = new AbstractConstruct(){

        public Object construct(Node node) {
            String value = ((ScalarNode)node).getValue();
            return new Scalar(value, ModelConstructor.getSource(node));
        }
    };

    public ModelConstructor() {
        super(Mapping.class, ModelConstructor.class.getClassLoader());
        this.yamlConstructors.put(Tag.BOOL, ConstructScalar);
        this.yamlConstructors.put(Tag.INT, ConstructScalar);
        this.yamlConstructors.put(Tag.STR, ConstructScalar);
    }

    private static Source getSource(Node node) {
        Mark mark = node.getStartMark();
        return new Source(mark.getName(), mark.getLine() + 1);
    }

    protected Map createDefaultMap(int initSize) {
        return new Mapping(initSize);
    }

    protected void constructMapping2ndStep(MappingNode node, final Map mapping) {
        ((Mapping)mapping).setSource(ModelConstructor.getSource((Node)node));
        super.constructMapping2ndStep(node, (Map)new AbstractMapDecorator(mapping){

            public Object put(Object key, Object value) {
                if (!(key instanceof Scalar)) {
                    throw new IllegalStateException("We only support scalar map keys");
                }
                Object scalar = ObjectUtils.clone((Object)value);
                if (scalar instanceof Number) {
                    scalar = new Scalar(scalar.toString());
                } else if (scalar instanceof Boolean) {
                    scalar = new Scalar(scalar.toString());
                }
                return mapping.put(key.toString(), scalar);
            }
        });
    }

    protected List createDefaultList(int initSize) {
        return new Sequence(initSize);
    }

    protected void constructSequenceStep2(SequenceNode node, Collection collection) {
        ((Sequence)collection).setSource(ModelConstructor.getSource((Node)node));
        super.constructSequenceStep2(node, collection);
    }
}

