/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.Node;
import hudson.model.UpdateCenter;
import hudson.model.labels.LabelAtom;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.EphemeralNode;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.Mapping;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=1.0)
@Restricted(value={NoExternalUse.class})
public class JenkinsConfigurator
extends BaseConfigurator<Jenkins>
implements RootElementConfigurator<Jenkins> {
    @Override
    public Class<Jenkins> getTarget() {
        return Jenkins.class;
    }

    @Override
    public Jenkins getTargetComponent(ConfigurationContext context) {
        return Jenkins.get();
    }

    @Override
    protected Jenkins instance(Mapping mapping, ConfigurationContext context) {
        return this.getTargetComponent(context);
    }

    @Override
    @NonNull
    public Set<Attribute<Jenkins, ?>> describe() {
        Set<Attribute<Jenkins, ?>> attributes = super.describe();
        attributes.add(new Attribute<Jenkins, AdminWhitelistRule>("remotingSecurity", AdminWhitelistRule.class).getter(j -> (AdminWhitelistRule)j.getInjector().getInstance(AdminWhitelistRule.class)).setter(Attribute.noop()));
        Attribute.get(attributes, "nodes").ifPresent(attribute -> attribute.getter(jenkins -> jenkins.getNodes().stream().filter(node -> !this.isCloudNode((Node)node)).collect(Collectors.toList())).setter((jenkins, configuredNodes) -> {
            List configuredNodesNames = configuredNodes.stream().map(Node::getNodeName).collect(Collectors.toList());
            List nodesToKeep = jenkins.getNodes().stream().filter(node -> !configuredNodesNames.contains(node.getNodeName())).filter(this::isCloudNode).collect(Collectors.toList());
            nodesToKeep.addAll(configuredNodes);
            jenkins.setNodes(nodesToKeep);
        }));
        attributes.add(new Attribute<Jenkins, UpdateCenter>("updateCenter", UpdateCenter.class).getter(Jenkins::getUpdateCenter).setter(Attribute.noop()));
        attributes.add(new MultivaluedAttribute<Jenkins, Collection>("labelAtoms", LabelAtom.class).getter(Jenkins::getLabelAtoms).setter((jenkins, labelAtoms) -> {
            for (LabelAtom labelAtom : labelAtoms) {
                LabelAtom atom = jenkins.getLabelAtom(labelAtom.getName());
                if (atom == null) continue;
                atom.getProperties().clear();
                atom.getProperties().addAll((Collection)labelAtom.getProperties());
            }
        }));
        attributes.add(new Attribute<Jenkins, ProxyConfiguration>("proxy", ProxyConfiguration.class).getter(j -> j.proxy).setter((o, v) -> {
            o.proxy = v;
        }));
        return attributes;
    }

    private boolean isCloudNode(Node node) {
        boolean instantiable = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> node.getDescriptor().isInstantiable()).getOrElse((Object)true);
        boolean cloudSlave = node instanceof AbstractCloudSlave;
        boolean ephemeral = node instanceof EphemeralNode;
        return !instantiable || cloudSlave || ephemeral;
    }

    @Override
    protected Set<String> exclusions() {
        return Collections.singleton("installState");
    }

    @Override
    @NonNull
    public String getName() {
        return "jenkins";
    }
}

