/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.util.VersionNumber;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Source;

@Extension
public class ObsoleteConfigurationMonitor
extends AdministrativeMonitor {
    private final List<Error> errors = new CopyOnWriteArrayList<Error>();

    public boolean isActivated() {
        return !this.errors.isEmpty();
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void reset() {
        this.errors.clear();
    }

    public void record(CNode node, String error) {
        this.errors.add(new Error(node.getSource(), error));
    }

    public static ObsoleteConfigurationMonitor get() {
        return (ObsoleteConfigurationMonitor)((Object)AdministrativeMonitor.all().get(ObsoleteConfigurationMonitor.class));
    }

    public String getCss() {
        VersionNumber version = Jenkins.getVersion();
        if (version == null || version.isNewerThan(new VersionNumber("2.103"))) {
            return "alert alert-warning";
        }
        return "warning";
    }

    public static class Error {
        public final Source source;
        public final String message;

        public Error(Source source, String message) {
            this.source = source;
            this.message = message;
        }
    }
}

