/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.ObsoleteConfigurationMonitor;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.jenkinsci.plugins.casc.yaml.ModelConstructor;
import org.jenkinsci.plugins.casc.yaml.YamlReader;
import org.jenkinsci.plugins.casc.yaml.YamlSource;
import org.jenkinsci.plugins.casc.yaml.YamlUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

@Extension
public class ConfigurationAsCode
extends ManagementLink {
    public static final String CASC_JENKINS_CONFIG_PROPERTY = "casc.jenkins.config";
    public static final String CASC_JENKINS_CONFIG_ENV = "CASC_JENKINS_CONFIG";
    public static final String DEFAULT_JENKINS_YAML_PATH = "./jenkins.yaml";
    public static final String YAML_FILES_PATTERN = "glob:**.{yml,yaml,YAML,YML}";
    public static final Logger LOGGER = Logger.getLogger(ConfigurationAsCode.class.getName());
    private long lastTimeLoaded;
    private List<String> sources = Collections.emptyList();
    private static final YamlReader<String> READ_FROM_URL = config -> {
        URL url = URI.create(config).toURL();
        return new InputStreamReader(url.openStream(), "UTF-8");
    };
    private static final YamlReader<Path> READ_FROM_PATH = Files::newBufferedReader;
    private Version version = Version.ONE;
    private Deprecation deprecation = Deprecation.reject;
    private Restricted restricted = Restricted.reject;

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/configuration-as-code/img/logo-head.svg";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Configuration as Code";
    }

    @CheckForNull
    public String getUrlName() {
        return "configuration-as-code";
    }

    public String getDescription() {
        return "An opinionated way to configure jenkins based on human-readable declarative configuration files";
    }

    public Date getLastTimeLoaded() {
        return new Date(this.lastTimeLoaded);
    }

    public List<String> getSources() {
        return this.sources;
    }

    @RequirePOST
    public void doReload(StaplerRequest request, StaplerResponse response) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            response.sendError(403);
            return;
        }
        this.configure();
        response.sendRedirect("");
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void init() throws Exception {
        ConfigurationAsCode.get().configure();
    }

    public void configure() throws ConfiguratorException {
        String configParameter;
        List<String> configParameters = this.getBundledCasCURIs();
        if (!configParameters.isEmpty()) {
            LOGGER.log(Level.FINE, "Located bundled config YAMLs: {0}", configParameters);
        }
        if ((configParameter = System.getProperty(CASC_JENKINS_CONFIG_PROPERTY, System.getenv(CASC_JENKINS_CONFIG_ENV))) == null && Files.exists(Paths.get(DEFAULT_JENKINS_YAML_PATH, new String[0]), new LinkOption[0])) {
            configParameter = DEFAULT_JENKINS_YAML_PATH;
        }
        if (configParameter != null) {
            configParameters.add(configParameter);
        }
        if (configParameters.isEmpty()) {
            LOGGER.log(Level.FINE, "No configuration set nor default config file");
            return;
        }
        this.configure(configParameters);
    }

    public List<String> getBundledCasCURIs() {
        String cascFile = "/WEB-INF/./jenkins.yaml";
        String cascDirectory = "/WEB-INF/./jenkins.yaml.d/";
        ArrayList<String> res = new ArrayList<String>();
        ServletContext servletContext = Jenkins.getInstance().servletContext;
        try {
            URL bundled = servletContext.getResource("/WEB-INF/./jenkins.yaml");
            if (bundled != null) {
                res.add(bundled.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load /WEB-INF/./jenkins.yaml", e);
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        Set resources = servletContext.getResourcePaths("/WEB-INF/./jenkins.yaml.d/");
        if (resources != null) {
            for (String cascItem : new TreeSet(resources)) {
                try {
                    URL bundled = servletContext.getResource(cascItem);
                    if (bundled == null || !matcher.matches(new File(bundled.getPath()).toPath())) continue;
                    res.add(bundled.toString());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to execute " + res, e);
                }
            }
        }
        return res;
    }

    @RequirePOST
    public void doExport(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        res.setContentType("application/x-yaml; charset=utf-8");
        res.addHeader("Content-Disposition", "attachment; filename=jenkins.yaml");
        ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
        for (RootElementConfigurator root : RootElementConfigurator.all()) {
            CNode config = root.describe(root.getTargetComponent());
            Node valueNode = this.toYaml(config);
            if (valueNode == null) continue;
            tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, root.getName(), null, null, DumperOptions.ScalarStyle.PLAIN.getChar()), valueNode));
        }
        MappingNode root = new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK.getStyleBoolean());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)res.getOutputStream(), StandardCharsets.UTF_8);){
            ConfigurationAsCode.serializeYamlNode((Node)root, writer);
        }
        catch (IOException e) {
            throw new YAMLException((Throwable)e);
        }
    }

    static void serializeYamlNode(Node root, Writer writer) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setPrettyFlow(true);
        Serializer serializer = new Serializer((Emitable)new Emitter(writer, options), new Resolver(), options, null);
        serializer.open();
        serializer.serialize(root);
        serializer.close();
    }

    @CheckForNull
    Node toYaml(CNode config) throws ConfiguratorException {
        if (config == null) {
            return null;
        }
        switch (config.getType()) {
            case MAPPING: {
                Mapping mapping = config.asMapping();
                ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
                ArrayList entries = new ArrayList(mapping.entrySet());
                entries.sort(Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : entries) {
                    Node valueNode = this.toYaml((CNode)entry.getValue());
                    if (valueNode == null) continue;
                    tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, (String)entry.getKey(), null, null, DumperOptions.ScalarStyle.PLAIN.getChar()), valueNode));
                }
                if (tuples.isEmpty()) {
                    return null;
                }
                return new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK.getStyleBoolean());
            }
            case SEQUENCE: {
                Sequence sequence = config.asSequence();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (CNode cNode : sequence) {
                    Node valueNode = this.toYaml(cNode);
                    if (valueNode == null) continue;
                    arrayList.add(valueNode);
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                return new SequenceNode(Tag.SEQ, arrayList, DumperOptions.FlowStyle.BLOCK.getStyleBoolean());
            }
        }
        Scalar scalar = config.asScalar();
        String value = scalar.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        return new ScalarNode(scalar.getTag(), value, null, null, scalar.isRaw() ? DumperOptions.ScalarStyle.PLAIN.getChar() : DumperOptions.ScalarStyle.DOUBLE_QUOTED.getChar());
    }

    public void configure(String ... configParameters) throws ConfiguratorException {
        this.configure(Arrays.asList(configParameters));
    }

    public void configure(Collection<String> configParameters) throws ConfiguratorException {
        ArrayList<YamlSource> configs = new ArrayList<YamlSource>();
        for (String p : configParameters) {
            if (ConfigurationAsCode.isSupportedURI(p)) {
                configs.add(new YamlSource<String>(p, READ_FROM_URL));
            } else {
                configs.addAll(this.configs(p).stream().map(s -> new YamlSource<Path>((Path)s, READ_FROM_PATH)).collect(Collectors.toList()));
            }
            this.sources = Collections.singletonList(p);
        }
        this.configureWith(configs);
        this.lastTimeLoaded = System.currentTimeMillis();
    }

    public static boolean isSupportedURI(String configurationParameter) {
        if (configurationParameter == null) {
            return false;
        }
        List<String> supportedProtocols = Arrays.asList("https", "http", "file");
        URI uri = URI.create(configurationParameter);
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        return supportedProtocols.contains(uri.getScheme());
    }

    private void configureWith(List<YamlSource> configs) throws ConfiguratorException {
        Node merged = YamlUtils.merge(configs);
        Mapping map = this.loadAs(merged);
        ConfigurationAsCode.configureWith(map.entrySet());
    }

    private Mapping loadAs(final Node node) {
        ModelConstructor constructor = new ModelConstructor();
        constructor.setComposer(new Composer(null, null){

            public Node getSingleNode() {
                return node;
            }
        });
        return (Mapping)constructor.getSingleData(Mapping.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> configs(String path) throws ConfiguratorException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        try (Stream<Path> stream = Files.find(Paths.get(path, new String[0]), Integer.MAX_VALUE, (next, attrs) -> attrs.isRegularFile() && matcher.matches((Path)next), new FileVisitOption[0]);){
            List<Path> list = stream.collect(Collectors.toList());
            return list;
        }
        catch (NoSuchFileException e) {
            throw new ConfiguratorException("File does not exist: " + path, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed config scan for " + path, e);
        }
    }

    private static Stream<? extends Map.Entry<String, Object>> entries(Reader config) {
        return ((Map)new Yaml().loadAs(config, Map.class)).entrySet().stream();
    }

    public static void configureWith(Set<Map.Entry<String, CNode>> entries) throws ConfiguratorException {
        ObsoleteConfigurationMonitor.get().reset();
        block2: for (RootElementConfigurator configurator : RootElementConfigurator.all()) {
            Iterator<Map.Entry<String, CNode>> it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry<String, CNode> entry = it.next();
                if (!entry.getKey().equalsIgnoreCase(configurator.getName())) continue;
                try {
                    configurator.configure(entry.getValue());
                    it.remove();
                    continue block2;
                }
                catch (ConfiguratorException e) {
                    throw new ConfiguratorException(configurator, String.format("error configuring <%s> with <%s> configurator", entry.getKey(), configurator.getName()), e);
                }
            }
        }
        if (!entries.isEmpty()) {
            Map.Entry<String, CNode> next = entries.iterator().next();
            throw new ConfiguratorException(String.format("No configurator for root element <%s>", next.getKey()));
        }
    }

    public static ConfigurationAsCode get() {
        return (ConfigurationAsCode)((Object)Jenkins.getInstance().getExtensionList(ConfigurationAsCode.class).get(0));
    }

    public Collection<?> getRootConfigurators() {
        return new LinkedHashSet<RootElementConfigurator>(RootElementConfigurator.all());
    }

    public Collection<?> getConfigurators() {
        List<RootElementConfigurator> roots = RootElementConfigurator.all();
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>(roots);
        for (RootElementConfigurator root : roots) {
            this.listElements(elements, root.describe());
        }
        return elements;
    }

    private void listElements(Set<Object> elements, Set<Attribute> attributes) {
        attributes.stream().map(Attribute::getType).map(Configurator::lookup).filter(Objects::nonNull).forEach(configurator -> {
            elements.addAll(configurator.getConfigurators());
            this.listElements(elements, configurator.describe());
        });
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isAtLeast(Version version) {
        return this.version.ordinal() >= version.ordinal();
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(Deprecation deprecation) {
        this.deprecation = deprecation;
    }

    public Restricted getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Restricted restricted) {
        this.restricted = restricted;
    }

    static enum Restricted {
        reject,
        beta,
        warn;

    }

    static enum Deprecation {
        reject,
        warn;

    }

    static enum Version {
        ONE("1");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version of(String version) throws ConfiguratorException {
            switch (version) {
                case "1": {
                    return ONE;
                }
            }
            throw new ConfiguratorException("unsupported version " + version);
        }

        public String value() {
            return this.value;
        }
    }
}

