/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.ExtensionList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;

public class ExtensionConfigurator<T>
extends BaseConfigurator<T> {
    private static final Logger logger = Logger.getLogger(ExtensionConfigurator.class.getName());
    private final Class<T> target;

    public ExtensionConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    public T configure(CNode c) throws ConfiguratorException {
        ExtensionList list = Jenkins.getInstance().getExtensionList(this.target);
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        Object o = list.get(0);
        if (c instanceof Map) {
            Mapping config = c.asMapping();
            Set<Attribute> attributes = this.describe();
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                if (!config.containsKey(name)) continue;
                Class k = attribute.getType();
                Configurator configurator = Configurator.lookup(k);
                if (configurator == null) {
                    throw new IllegalStateException("No configurator implementation to manage " + k);
                }
                CNode yaml = (CNode)config.get(name);
                Object value = configurator.configure(yaml);
                try {
                    logger.info("Setting " + o + '.' + name + " = " + (yaml.isSensitiveData() ? "****" : value));
                    attribute.setValue(o, value);
                }
                catch (Exception e) {
                    throw new ConfiguratorException(this, "Failed to set attribute " + attribute, e);
                }
            }
        }
        return (T)o;
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        T ref = this.target.newInstance();
        return this.compare(instance, ref);
    }
}

