/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.yaml;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.yaml.StreamReaderWithSource;
import org.jenkinsci.plugins.casc.yaml.YamlSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.resolver.Resolver;

@Restricted(value={NoExternalUse.class})
public final class YamlUtils {
    public static Node merge(List<YamlSource> configs) throws ConfiguratorException {
        Node root = null;
        for (YamlSource source : configs) {
            try {
                Reader r = source.read();
                Throwable throwable = null;
                try {
                    Node node = YamlUtils.read(source);
                    if (root == null) {
                        root = node;
                        continue;
                    }
                    YamlUtils.merge(root, node, source.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (IOException io) {
                throw new ConfiguratorException("Failed to read " + source, io);
            }
        }
        return root;
    }

    public static Node read(YamlSource source) throws IOException {
        Composer composer = new Composer((Parser)new ParserImpl((StreamReader)new StreamReaderWithSource(source)), new Resolver());
        return composer.getSingleNode();
    }

    private static void merge(Node root, Node node, String source) throws ConfiguratorException {
        if (root.getNodeId() != node.getNodeId()) {
            throw new ConfiguratorException(String.format("Found incompatible configuration elements %s %s", source, node.getStartMark()));
        }
        switch (root.getNodeId()) {
            case sequence: {
                SequenceNode seq = (SequenceNode)root;
                SequenceNode seq2 = (SequenceNode)node;
                seq.getValue().addAll(seq2.getValue());
                return;
            }
            case mapping: {
                MappingNode map = (MappingNode)root;
                MappingNode map2 = (MappingNode)node;
                Iterator it = map2.getValue().iterator();
                while (it.hasNext()) {
                    NodeTuple t2 = (NodeTuple)it.next();
                    for (NodeTuple tuple : map.getValue()) {
                        Node key = tuple.getKeyNode();
                        Node key2 = t2.getKeyNode();
                        if (key.getNodeId() == NodeId.scalar) {
                            if (!((ScalarNode)key).getValue().equals(((ScalarNode)key2).getValue())) continue;
                            YamlUtils.merge(tuple.getValueNode(), t2.getValueNode(), source);
                            it.remove();
                            continue;
                        }
                        throw new ConfiguratorException(String.format("Found unmergeable configuration keys %s %s)", source, node.getEndMark()));
                    }
                }
                map.getValue().addAll(map2.getValue());
                return;
            }
        }
        throw new ConfiguratorException(String.format("Found conflicting configuration at %s %s", source.toString(), node.getStartMark()));
    }
}

