/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class EnumConfigurator<T extends Enum<T>>
extends Configurator<T> {
    private final Class<T> clazz;

    public EnumConfigurator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class getTarget() {
        return this.clazz;
    }

    @Override
    @Nonnull
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    @Override
    @Nonnull
    public T configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return Enum.valueOf(this.clazz, config.asScalar().getValue());
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return (T)this.configure(config, context);
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        return new Scalar(((Enum)instance).name());
    }
}

