/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.InputStream;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.ConfigurationAsCode;
import org.jenkinsci.plugins.casc.model.Source;
import org.jenkinsci.plugins.casc.yaml.YamlSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class CheckConfigurationCommand
extends CLICommand {
    public String getShortDescription() {
        return "Apply YAML configuration to instance";
    }

    protected int run() throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return -1;
        }
        Map<Source, String> issues = ConfigurationAsCode.get().checkWith(new YamlSource<InputStream>(this.stdin, YamlSource.READ_FROM_INPUTSTREAM));
        for (Map.Entry<Source, String> entry : issues.entrySet()) {
            this.stderr.printf("warning: line %d %s", entry.getKey().line, entry.getValue());
        }
        return 0;
    }
}

