/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.ExtensionPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class SecretSource
implements ExtensionPoint {
    public static final Pattern SECRET_PATTERN = Pattern.compile("\\$\\{([^:\\s]*)(?::-)?([^}\\s]*)?\\}");

    public static Optional<String> requiresReveal(String key) {
        Matcher m = SECRET_PATTERN.matcher(key);
        if (m.matches()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }

    public abstract Optional<String> reveal(String var1) throws IOException;

    public static List<SecretSource> all() {
        ArrayList<SecretSource> all = new ArrayList<SecretSource>();
        all.addAll((Collection<SecretSource>)Jenkins.getInstance().getExtensionList(SecretSource.class));
        return all;
    }

    public static Optional<String> defaultValue(String key) {
        Matcher m = SECRET_PATTERN.matcher(key);
        if (m.matches() && m.groupCount() == 2) {
            return Optional.ofNullable(m.group(2));
        }
        return Optional.empty();
    }
}

