/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.casc.model.CNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.Stapler;

@Restricted(value={Beta.class})
public class ConfigurationContext {
    private Deprecation deprecation = Deprecation.reject;
    private Restriction restriction = Restriction.reject;
    private Unknown unknown = Unknown.reject;
    private List<Listener> listeners = new ArrayList<Listener>();
    private Version version = Version.ONE;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void warning(@Nonnull CNode node, @Nonnull String message) {
        for (Listener listener : this.listeners) {
            listener.warning(node, message);
        }
    }

    public Deprecation getDeprecated() {
        return this.deprecation;
    }

    public Restriction getRestricted() {
        return this.restriction;
    }

    public Unknown getUnknown() {
        return this.unknown;
    }

    public void setDeprecated(Deprecation deprecation) {
        this.deprecation = deprecation;
    }

    public void setRestricted(Restriction restriction) {
        this.restriction = restriction;
    }

    public void setUnknown(Unknown unknown) {
        this.unknown = unknown;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    static {
        Stapler.CONVERT_UTILS.register((type, value) -> Version.of(value.toString()), Version.class);
    }

    @FunctionalInterface
    public static interface Listener {
        public void warning(@Nonnull CNode var1, @Nonnull String var2);
    }

    static enum Deprecation {
        reject,
        warn;

    }

    static enum Restriction {
        reject,
        beta,
        warn;

    }

    static enum Unknown {
        reject,
        warn;

    }

    static enum Version {
        ONE("1");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version of(String version) {
            switch (version) {
                case "1": {
                    return ONE;
                }
            }
            throw new IllegalArgumentException("unsupported version " + version);
        }

        public String value() {
            return this.value;
        }

        public boolean isAtLeast(Version version) {
            return this.ordinal() >= version.ordinal();
        }
    }
}

