/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
public class PrimitiveConfigurator
extends Configurator {
    private final Class target;

    public PrimitiveConfigurator(Class clazz) {
        this.target = clazz;
    }

    public Class getTarget() {
        return this.target;
    }

    @Override
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Object configure(CNode config) throws ConfiguratorException {
        return Stapler.lookupConverter((Class)this.target).convert(this.target, (Object)config);
    }

    @Override
    public Object check(CNode config) throws ConfiguratorException {
        return this.configure(config);
    }

    @Override
    @CheckForNull
    public CNode describe(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof Number) {
            return new Scalar((Number)instance);
        }
        if (instance instanceof Boolean) {
            return new Scalar((Boolean)instance);
        }
        if (this.target.isEnum()) {
            return new Scalar((Enum)instance);
        }
        return new Scalar(String.valueOf(instance));
    }

    @Override
    public List<Configurator> getConfigurators() {
        return Collections.EMPTY_LIST;
    }
}

