/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.attributes;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class DescribableAttribute<Owner, Type>
extends Attribute<Owner, Type> {
    public DescribableAttribute(String name, Class<? extends Describable> type) {
        super(name, type);
    }

    @Override
    public List<String> possibleValues() {
        DescriptorExtensionList descriptors = Jenkins.getInstance().getDescriptorList(this.type);
        return descriptors.stream().map(d -> DescribableAttribute.getPreferredSymbol(d, this.type, d.getKlass().toJavaClass())).collect(Collectors.toList());
    }

    public static String getPreferredSymbol(Descriptor d, Class extensionPoint, Class target) {
        return DescribableAttribute.getSymbols(d, extensionPoint, target).get(0);
    }

    public static List<String> getSymbols(Descriptor d, Class extensionPoint, Class target) {
        if (d != null) {
            String in;
            ArrayList<String> symbols = new ArrayList<String>();
            Symbol s = d.getClass().getAnnotation(Symbol.class);
            if (s != null) {
                symbols.addAll(Arrays.asList(s.value()));
            }
            String ext = extensionPoint.getSimpleName();
            String cn = d.getKlass().toJavaClass().getSimpleName();
            if (cn.endsWith(ext)) {
                symbols.add(Configurator.normalize(cn.substring(0, cn.length() - ext.length())));
            }
            if (cn.endsWith(in = extensionPoint.getSimpleName() + "Impl")) {
                symbols.add(Configurator.normalize(cn.substring(0, cn.length() - in.length())));
            }
            symbols.add(Configurator.normalize(cn));
            return symbols;
        }
        return Collections.singletonList(Configurator.normalize(target.getSimpleName()));
    }
}

