/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class LegacyDataBoundConstructorProvider<TTarget>
implements ExtensionPoint {
    @Nonnull
    public abstract Set<Constructor<TTarget>> getConstructorsFor(@Nonnull Class<?> var1);

    @Nonnull
    public static <T> Set<Constructor<T>> getLegacyDataBoundConstructors(@Nonnull Class<T> targetClazz) {
        HashSet<Constructor<T>> constructors = new HashSet<Constructor<T>>();
        for (LegacyDataBoundConstructorProvider provider : LegacyDataBoundConstructorProvider.all()) {
            Set provided = provider.getConstructorsFor(targetClazz);
            for (Constructor pr : provided) {
                if (targetClazz.isAssignableFrom(pr.getDeclaringClass())) {
                    constructors.add(pr);
                    continue;
                }
                throw new IllegalStateException("Extension " + provider + " provided a wrong constructor type for " + targetClazz);
            }
        }
        return constructors;
    }

    @Nonnull
    public static ExtensionList<LegacyDataBoundConstructorProvider> all() {
        return ExtensionList.lookup(LegacyDataBoundConstructorProvider.class);
    }
}

