/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.listeners.NodeDownstreamBuildAction;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeLogResource;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.modeldefinition.Utils;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartDeclarativePipelineAction;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeImpl
extends BluePipelineNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineNodeImpl.class);
    private final FlowNodeWrapper node;
    private final List<BluePipelineNode.Edge> edges;
    private final Long durationInMillis;
    private final NodeRunStatus status;
    private final Link self;
    private final String runExternalizableId;
    private final Reachable parent;
    private final boolean restartable;
    public static final int waitJobInqueueTimeout = Integer.getInteger("blueocean.wait.job.inqueue", 1000);

    public PipelineNodeImpl(FlowNodeWrapper node, Reachable parent, WorkflowRun run) {
        RestartDeclarativePipelineAction restartDeclarativePipelineAction;
        this.node = node;
        this.runExternalizableId = run.getExternalizableId();
        this.edges = this.buildEdges(node.edges);
        this.status = node.getStatus();
        this.durationInMillis = node.getTiming().getTotalDurationMillis();
        this.self = parent.getLink().rel(node.getId());
        this.parent = parent;
        this.restartable = this.getStateObj() == BlueRun.BlueRunState.FINISHED ? (restartDeclarativePipelineAction = (RestartDeclarativePipelineAction)run.getAction(RestartDeclarativePipelineAction.class)) != null && restartDeclarativePipelineAction.isRestartEnabled() && this.isRestartable(this.getDisplayName()) : false;
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node.getNode());
    }

    public String getDisplayDescription() {
        return null;
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @CheckForNull
    public String getFirstParent() {
        return this.node.getFirstParent() == null ? null : this.node.getFirstParent().getId();
    }

    public Date getStartTime() {
        long nodeTime = this.node.getTiming().getStartTimeMillis();
        if (nodeTime == 0L) {
            return null;
        }
        return new Date(nodeTime);
    }

    public String getStartTimeString() {
        if (this.getStartTime() == null) {
            return null;
        }
        return AbstractRunImpl.DATE_FORMAT.format(this.getStartTime().toInstant());
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return new NodeLogResource(this);
    }

    public String getType() {
        return this.node.getType().name();
    }

    public String getStepType() {
        throw new UnsupportedOperationException("not supported");
    }

    public String getCauseOfBlockage() {
        return this.node.getCauseOfFailure();
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.self, this.runExternalizableId);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        HashSet<NodeDownstreamBuildAction> actions = new HashSet<NodeDownstreamBuildAction>();
        actions.addAll(this.node.getNode().getActions());
        actions.addAll(this.node.getPipelineActions(NodeDownstreamBuildAction.class));
        return ActionProxiesImpl.getActionProxies(actions, input -> input instanceof LogAction || input instanceof NodeDownstreamBuildAction, (Reachable)this);
    }

    private WorkflowRun getRun() {
        return PipelineRunImpl.findRun(this.runExternalizableId);
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    @CheckForNull
    private CpsFlowExecution getExecution() {
        FlowExecutionOwner owner = this.getRun().asFlowExecutionOwner();
        FlowExecution exec = owner.getOrNull();
        return exec instanceof CpsFlowExecution ? (CpsFlowExecution)exec : null;
    }

    private boolean isRestartable(String stageName) {
        ModelASTStages stages;
        ExecutionModelAction execAction;
        CpsFlowExecution execution = this.getExecution();
        if (execution != null && (execAction = (ExecutionModelAction)this.getRun().getAction(ExecutionModelAction.class)) != null && (stages = execAction.getStages()) != null) {
            for (ModelASTStage s : stages.getStages()) {
                if (!s.getName().equals(stageName)) continue;
                return !Utils.stageHasStatusOf((String)s.getName(), (FlowExecution)execution, (String[])new String[]{StageStatus.getSkippedForFailure(), StageStatus.getSkippedForUnstable()});
            }
        }
        return false;
    }

    public BlueInputStep getInputStep() {
        return null;
    }

    public HttpResponse submitInputStep(StaplerRequest request) {
        return null;
    }

    public HttpResponse restart(StaplerRequest request) {
        try {
            WorkflowRun run = this.getRun();
            JSONObject body = JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
            boolean restart = body.getBoolean("restart");
            if (restart && this.isRestartable()) {
                LOGGER.debug("submitInputStep, restart: {}, step: {}", (Object)restart, (Object)this.getDisplayName());
                RestartDeclarativePipelineAction restartDeclarativePipelineAction = (RestartDeclarativePipelineAction)run.getAction(RestartDeclarativePipelineAction.class);
                Queue.Item item = restartDeclarativePipelineAction.run(this.getDisplayName());
                BluePipeline bluePipeline = BluePipelineFactory.getPipelineInstance((Item)run.getParent(), (Reachable)this.parent);
                BlueQueueItem queueItem = QueueUtil.getQueuedItem((BlueOrganization)bluePipeline.getOrganization(), (Queue.Item)item, (Job)run.getParent());
                if (queueItem != null) {
                    return (req, rsp, node1) -> {
                        rsp.setStatus(200);
                        rsp.getOutputStream().print(Export.toJson((Object)queueItem.toRun()));
                    };
                }
                WorkflowRun restartRun = PipelineNodeImpl.getRun((WorkflowJob)run.getParent(), item.getId());
                if (restartRun != null) {
                    return (req, rsp, node1) -> {
                        rsp.setStatus(200);
                        rsp.getOutputStream().print(Export.toJson((Object)((Object)new PipelineRunImpl(restartRun, this.parent, bluePipeline.getOrganization()))));
                    };
                }
                throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("error restarting stage: " + e.getMessage(), (Throwable)e);
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
        return null;
    }

    protected static WorkflowRun getRun(WorkflowJob job, long itemId) throws InterruptedException {
        WorkflowRun restartRun = (WorkflowRun)QueueUtil.getRun((Job)job, (long)itemId);
        if (restartRun == null) {
            long startTimeMs = System.currentTimeMillis();
            while (restartRun == null && System.currentTimeMillis() - startTimeMs < (long)waitJobInqueueTimeout) {
                Thread.sleep(100L);
                restartRun = (WorkflowRun)QueueUtil.getRun((Job)job, (long)itemId);
            }
        }
        return restartRun;
    }

    private List<BluePipelineNode.Edge> buildEdges(List<FlowNodeWrapper> nodes) {
        return nodes.isEmpty() ? Collections.emptyList() : nodes.stream().map(EdgeImpl::new).collect(Collectors.toList());
    }

    FlowNodeWrapper getFlowNodeWrapper() {
        return this.node;
    }

    public String toString() {
        return "PipelineNodeImpl{node=" + this.node + ", edges=" + this.edges + ", status=" + this.status + "}";
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final String id;
        private final String type;

        public EdgeImpl(FlowNodeWrapper edge) {
            this.id = edge.getId();
            this.type = edge.getType().name();
        }

        public String getId() {
            return this.id;
        }

        @Exported
        public String getType() {
            return this.type;
        }
    }
}

