/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import java.util.concurrent.TimeUnit;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import org.apache.commons.lang3.StringUtils;

class Caches {
    static final long PR_METADATA_CACHE_MAX_SIZE = Long.getLong("PR_METADATA_CACHE_MAX_SIZE", 10000L);
    static final long BRANCH_METADATA_CACHE_MAX_SIZE = Long.getLong("BRANCH_METADATA_CACHE_MAX_SIZE", 10000L);
    static final LoadingCache<String, BranchImpl.PullRequest> PULL_REQUEST_METADATA = Caffeine.newBuilder().maximumSize(PR_METADATA_CACHE_MAX_SIZE).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new PullRequestCacheLoader(null));
    static final LoadingCache<String, BranchImpl.Branch> BRANCH_METADATA = Caffeine.newBuilder().maximumSize(BRANCH_METADATA_CACHE_MAX_SIZE).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new BranchCacheLoader(null));

    private Caches() {
    }

    static class PullRequestCacheLoader
    implements CacheLoader<String, BranchImpl.PullRequest> {
        private Jenkins jenkins;

        PullRequestCacheLoader(@Nullable Jenkins jenkins) {
            this.jenkins = jenkins;
        }

        public BranchImpl.PullRequest load(String key) throws Exception {
            Jenkins jenkins = this.jenkins != null ? this.jenkins : Jenkins.get();
            Job job = (Job)jenkins.getItemByFullName(key, Job.class);
            if (job == null) {
                return null;
            }
            SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
            if (head instanceof ChangeRequestSCMHead) {
                ChangeRequestSCMHead cr = (ChangeRequestSCMHead)head;
                ObjectMetadataAction om = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
                ContributorMetadataAction cm = (ContributorMetadataAction)job.getAction(ContributorMetadataAction.class);
                return new BranchImpl.PullRequest(cr.getId(), om != null ? om.getObjectUrl() : null, om != null ? om.getObjectDisplayName() : null, cm != null ? cm.getContributor() : null);
            }
            return null;
        }
    }

    static class BranchCacheLoader
    implements CacheLoader<String, BranchImpl.Branch> {
        private Jenkins jenkins;

        BranchCacheLoader(@Nullable Jenkins jenkins) {
            this.jenkins = jenkins;
        }

        public BranchImpl.Branch load(String key) throws Exception {
            BranchProjectFactory projectFactory;
            ItemGroup parent;
            String url;
            Jenkins jenkins = this.jenkins != null ? this.jenkins : Jenkins.get();
            Job job = (Job)jenkins.getItemByFullName(key, Job.class);
            if (job == null) {
                return null;
            }
            ObjectMetadataAction om = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
            PrimaryInstanceMetadataAction pima = (PrimaryInstanceMetadataAction)job.getAction(PrimaryInstanceMetadataAction.class);
            String string = url = om != null && om.getObjectUrl() != null ? om.getObjectUrl() : null;
            if (StringUtils.isEmpty(url) && (parent = job.getParent()) instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)job)) {
                SCMHead head = projectFactory.getBranch(job).getHead();
                url = head.getName();
            }
            if (StringUtils.isEmpty((CharSequence)url) && pima == null) {
                return null;
            }
            return new BranchImpl.Branch(url, pima != null, BlueIssueFactory.resolve((Job)job));
        }
    }

    @Extension
    public static class ListenerImpl
    extends ItemListener {
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.invalidate((Object)oldFullName);
            BRANCH_METADATA.invalidate((Object)oldFullName);
            PULL_REQUEST_METADATA.refresh((Object)newFullName);
            BRANCH_METADATA.refresh((Object)newFullName);
        }

        public void onUpdated(Item item) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.refresh((Object)item.getFullName());
            BRANCH_METADATA.refresh((Object)item.getFullName());
        }

        public void onDeleted(Item item) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.invalidate((Object)item.getFullName());
            BRANCH_METADATA.invalidate((Object)item.getFullName());
        }
    }
}

