/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;

public class MultiBranchPipelineQueueContainer
extends BlueQueueContainer {
    private final MultiBranchPipelineImpl multiBranchPipeline;
    private final Link self;

    public MultiBranchPipelineQueueContainer(MultiBranchPipelineImpl multiBranchPipeline) {
        this.multiBranchPipeline = multiBranchPipeline;
        this.self = multiBranchPipeline.getLink().rel("queue");
    }

    public BlueQueueItem get(String name) {
        try {
            Job job;
            Queue.Item item = Jenkins.get().getQueue().getItem(Long.parseLong(name));
            if (item != null && item.task instanceof Job && (job = (Job)item.task).getParent() != null && job.getParent().getFullName().equals(this.multiBranchPipeline.mbp.getFullName())) {
                return QueueUtil.getQueuedItem((BlueOrganization)this.multiBranchPipeline.getOrganization(), (Queue.Item)item, (Job)job);
            }
        }
        catch (NumberFormatException e) {
            throw new ServiceException.BadRequestException("Invalid queue id: " + name + ". Must be a number.", (Throwable)e);
        }
        return null;
    }

    public Link getLink() {
        return this.self;
    }

    public Iterator<BlueQueueItem> iterator() {
        ArrayList queueItems = new ArrayList();
        for (Object o : this.multiBranchPipeline.mbp.getItems()) {
            if (!(o instanceof Job)) continue;
            queueItems.addAll(QueueUtil.getQueuedItems((BlueOrganization)this.multiBranchPipeline.getOrganization(), (Job)((Job)o)));
        }
        return queueItems.iterator();
    }

    public Iterator<BlueQueueItem> iterator(int start, int limit) {
        List branches = StreamSupport.stream(this.multiBranchPipeline.getBranches().spliterator(), false).sorted((o1, o2) -> PipelineRunImpl.LATEST_RUN_START_TIME_COMPARATOR.compare(o1.getLatestRun(), o2.getLatestRun())).collect(Collectors.toList());
        int l = branches.size() > 0 && limit / branches.size() > 0 ? limit / branches.size() : 1;
        int s = 0;
        if (start > 0) {
            s = Math.max(start - l, 0);
        }
        ArrayList<BlueQueueItem> c = new ArrayList<BlueQueueItem>();
        int count = 0;
        for (int retry = 0; retry < 5 && count < limit; ++retry) {
            for (BluePipeline b : branches) {
                Iterator it = b.getQueue().iterator(s, l);
                while (it.hasNext()) {
                    ++count;
                    c.add((BlueQueueItem)it.next());
                }
            }
        }
        c.sort((o1, o2) -> o2.getQueuedTime().compareTo(o1.getQueuedTime()));
        return c.iterator();
    }
}

