/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.preload.BlueUrlTokenizer;
import io.jenkins.blueocean.preload.RESTFetchPreloader;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;

@Extension
public class PipelineBranchRunStatePreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(PipelineBranchRunStatePreloader.class.getName());

    @Override
    protected RESTFetchPreloader.FetchData getFetchData(@NonNull BlueUrlTokenizer blueUrl) {
        block9: {
            if (!blueUrl.hasPart(BlueUrlTokenizer.UrlPart.BRANCH) || !blueUrl.hasPart(BlueUrlTokenizer.UrlPart.PIPELINE_RUN_DETAIL_ID)) {
                return null;
            }
            Jenkins jenkins = Jenkins.getInstance();
            String pipelineFullName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE);
            String branchName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.BRANCH);
            String runId = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE_RUN_DETAIL_ID);
            Item pipelineJobItem = jenkins.getItemByFullName(pipelineFullName);
            if (pipelineJobItem instanceof MultiBranchProject) {
                try {
                    MultiBranchProject pipelineMBP = (MultiBranchProject)pipelineJobItem;
                    Job pipelineBranchJob = pipelineMBP.getItem(branchName);
                    if (pipelineBranchJob != null) {
                        Run run = pipelineBranchJob.getBuild(runId);
                        if (run != null) {
                            BlueRun blueRun = BlueRunFactory.getRun((Run)run, (Reachable)BluePipelineFactory.resolve((Item)pipelineBranchJob));
                            if (blueRun != null) {
                                try {
                                    return new RESTFetchPreloader.FetchData(blueRun.getLink().getHref(), Export.toJson((Object)blueRun));
                                }
                                catch (IOException e) {
                                    LOGGER.log(Level.FINE, String.format("Unable to preload run for pipeline '%s'. Run serialization error.", run.getUrl()), e);
                                    return null;
                                }
                            }
                            LOGGER.log(Level.FINE, String.format("Unable to find run %s on branch named %s on pipeline named '%s'.", runId, branchName, pipelineFullName));
                            return null;
                        }
                        break block9;
                    }
                    LOGGER.log(Level.FINE, String.format("Unable to find branch named %s on pipeline named '%s'.", branchName, pipelineFullName));
                    return null;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, String.format("Unable to find run from pipeline named '%s'.", pipelineFullName), e);
                    return null;
                }
            }
            LOGGER.log(Level.FINE, String.format("Unable to find pipeline named '%s'.", pipelineFullName));
            return null;
        }
        return null;
    }
}

