/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.preload.BlueUrlTokenizer;
import io.jenkins.blueocean.preload.RESTFetchPreloader;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.model.BluePipeline;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

@Extension
public class PipelineStatePreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(PipelineStatePreloader.class.getName());

    @Override
    protected RESTFetchPreloader.FetchData getFetchData(@Nonnull BlueUrlTokenizer blueUrl) {
        if (!blueUrl.hasPart(BlueUrlTokenizer.UrlPart.PIPELINE)) {
            return null;
        }
        Jenkins jenkins = Jenkins.getInstance();
        String pipelineFullName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE);
        try {
            Item pipelineJobItem = jenkins.getItemByFullName(pipelineFullName);
            if (pipelineJobItem != null) {
                BluePipeline bluePipeline = (BluePipeline)BluePipelineFactory.resolve((Item)pipelineJobItem);
                if (bluePipeline != null) {
                    try {
                        return new RESTFetchPreloader.FetchData(bluePipeline.getLink().getHref(), Export.toJson((Object)bluePipeline));
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, String.format("Unable to preload pipeline '%s'. Serialization error.", pipelineJobItem.getUrl()), e);
                        return null;
                    }
                }
                LOGGER.log(Level.FINE, String.format("Unable to preload pipeline '%s'. Failed to convert to Blue Ocean Resource.", pipelineJobItem.getUrl()));
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, String.format("Unable to find pipeline named '%s'.", pipelineFullName), e);
            return null;
        }
        return null;
    }
}

