/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import java.util.Iterator;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineStepContainerImpl
extends BluePipelineStepContainer {
    private final FlowNodeWrapper node;
    private final Link self;
    private final WorkflowRun run;

    public PipelineStepContainerImpl(FlowNodeWrapper node, Link parentLink, WorkflowRun run) {
        this.self = parentLink.rel("steps");
        this.node = node;
        this.run = run;
    }

    public PipelineStepContainerImpl(WorkflowRun run, Link parentLink) {
        this.self = parentLink.rel("steps");
        this.node = null;
        this.run = run;
    }

    public BluePipelineStep get(String name) {
        NodeGraphBuilder builder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(this.run);
        return builder.getPipelineNodeStep(name, this.getLink());
    }

    public Iterator<BluePipelineStep> iterator() {
        NodeGraphBuilder builder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(this.run);
        return this.node == null ? builder.getPipelineNodeSteps(this.getLink()).iterator() : builder.getPipelineNodeSteps(this.node.getId(), this.getLink()).iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

