/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepVisitor;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeGraphVisitor
extends StandardChunkVisitor
implements NodeGraphBuilder {
    private final WorkflowRun run;
    private final ArrayDeque<FlowNodeWrapper> parallelBranches = new ArrayDeque();
    public final ArrayDeque<FlowNodeWrapper> nodes = new ArrayDeque();
    private FlowNode firstExecuted = null;
    private FlowNodeWrapper nextStage;
    private FlowNode parallelEnd;
    public final Map<String, FlowNodeWrapper> nodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
    private static final Logger logger = LoggerFactory.getLogger(PipelineNodeGraphVisitor.class);
    private static final boolean isNodeVisitorDumpEnabled = Boolean.getBoolean("NODE-DUMP-ENABLED");
    private final Stack<FlowNode> nestedStages = new Stack();
    private final Stack<FlowNode> nestedbranches = new Stack();
    private final ArrayDeque<FlowNode> pendingInputSteps = new ArrayDeque();
    private final Stack<FlowNode> parallelBranchEndNodes = new Stack();
    private final InputAction inputAction;
    private StepStartNode agentNode = null;
    private static final String PARALLEL_SYNTHETIC_STAGE_NAME = "Parallel";

    public PipelineNodeGraphVisitor(WorkflowRun run) {
        this.run = run;
        this.inputAction = (InputAction)run.getAction(InputAction.class);
        FlowExecution execution = run.getExecution();
        if (execution != null) {
            ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)this, (ChunkFinder)new StageChunkFinder());
        }
    }

    public void chunkStart(@Nonnull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @Nonnull ForkScanner scanner) {
        super.chunkStart(startNode, beforeBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkStart=> id: %s, name: %s, function: %s", startNode.getId(), startNode.getDisplayName(), startNode.getDisplayFunctionName()));
        }
        if (PipelineNodeUtil.isSyntheticStage(startNode)) {
            return;
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)startNode)) {
            this.firstExecuted = startNode;
        }
    }

    public void chunkEnd(@Nonnull FlowNode endNode, @CheckForNull FlowNode afterBlock, @Nonnull ForkScanner scanner) {
        super.chunkEnd(endNode, afterBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkEnd=> id: %s, name: %s, function: %s, type:%s", endNode.getId(), endNode.getDisplayName(), endNode.getDisplayFunctionName(), endNode.getClass()));
        }
        if (isNodeVisitorDumpEnabled && endNode instanceof StepEndNode) {
            this.dump("\tStartNode: " + ((StepEndNode)endNode).getStartNode());
        }
        if (endNode instanceof StepStartNode && endNode.getDisplayFunctionName().equals("node")) {
            this.agentNode = (StepStartNode)endNode;
        }
        this.captureOrphanParallelBranches();
        if (this.parallelEnd == null && endNode instanceof StepEndNode && !PipelineNodeUtil.isSyntheticStage((FlowNode)((StepEndNode)endNode).getStartNode()) && PipelineNodeUtil.isStage((FlowNode)((StepEndNode)endNode).getStartNode())) {
            FlowNode node = null;
            if (!this.nestedStages.empty()) {
                node = this.nestedStages.peek();
            }
            if (node == null || !node.equals((Object)endNode)) {
                this.nestedStages.push(endNode);
            }
        }
        this.firstExecuted = null;
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterBlock, scanner);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="chunk.getLastNode() is marked non null but is null sometimes, when JENKINS-40200 is fixed we will remove this check ")
    protected void handleChunkDone(@Nonnull MemoryFlowChunk chunk) {
        boolean skippedStage;
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("handleChunkDone=> id: %s, name: %s, function: %s", chunk.getFirstNode().getId(), chunk.getFirstNode().getDisplayName(), chunk.getFirstNode().getDisplayFunctionName()));
        }
        if (PipelineNodeUtil.isSyntheticStage(chunk.getFirstNode())) {
            return;
        }
        if (this.parallelEnd != null) {
            return;
        }
        if (!this.nestedStages.empty()) {
            this.nestedStages.pop();
            if (!this.nestedStages.empty()) {
                return;
            }
        }
        TimingInfo times = null;
        if (this.firstExecuted != null && chunk.getLastNode() != null) {
            times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)chunk.getPauseTimeMillis(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter());
        }
        if (times == null) {
            times = new TimingInfo();
        }
        NodeRunStatus status = (skippedStage = PipelineNodeUtil.isSkippedStage(chunk.getFirstNode())) ? new NodeRunStatus(BlueRun.BlueRunResult.NOT_BUILT, BlueRun.BlueRunState.SKIPPED) : (this.firstExecuted == null ? new NodeRunStatus(GenericStatus.NOT_EXECUTED) : (chunk.getLastNode() != null ? new NodeRunStatus(StatusAndTiming.computeChunkStatus((WorkflowRun)this.run, (FlowNode)chunk.getNodeBefore(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter())) : new NodeRunStatus(this.firstExecuted)));
        if (!this.pendingInputSteps.isEmpty()) {
            status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED);
        }
        FlowNodeWrapper stage = new FlowNodeWrapper(chunk.getFirstNode(), status, times, this.run);
        try {
            String cause = PipelineNodeUtil.getCauseOfBlockage(stage.getNode(), (FlowNode)this.agentNode, this.run);
            stage.setCauseOfFailure(cause);
        }
        catch (IOException | InterruptedException e) {
            logger.error(String.format("Error trying to get blockage status of pipeline: %s, runId: %s node block: %s. %s", ((WorkflowJob)this.run.getParent()).getFullName(), this.run.getId(), this.agentNode, e.getMessage()), (Throwable)e);
        }
        this.nodes.push(stage);
        this.nodeMap.put(stage.getId(), stage);
        if (!skippedStage && !this.parallelBranches.isEmpty()) {
            Iterator<FlowNodeWrapper> branches = this.parallelBranches.descendingIterator();
            while (branches.hasNext()) {
                FlowNodeWrapper p = branches.next();
                p.addParent(stage);
                stage.addEdge(p.getId());
            }
        } else if (this.nextStage != null) {
            this.nextStage.addParent(stage);
            stage.addEdge(this.nextStage.getId());
        }
        this.parallelBranches.clear();
        this.nextStage = stage;
    }

    protected void resetChunk(@Nonnull MemoryFlowChunk chunk) {
        super.resetChunk(chunk);
        this.firstExecuted = null;
        this.pendingInputSteps.clear();
    }

    public void parallelStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelStart=> id: %s, name: %s, function: %s", parallelStartNode.getId(), parallelStartNode.getDisplayName(), parallelStartNode.getDisplayFunctionName()));
            this.dump(String.format("\tbranch=> id: %s, name: %s, function: %s", branchNode.getId(), branchNode.getDisplayName(), branchNode.getDisplayFunctionName()));
        }
        if (this.nestedbranches.size() != this.parallelBranchEndNodes.size()) {
            logger.error(String.format("nestedBranches size: %s not equal to parallelBranchEndNodes: %s", this.nestedbranches.size(), this.parallelBranchEndNodes.size()));
            return;
        }
        while (!this.nestedbranches.empty() && !this.parallelBranchEndNodes.empty()) {
            NodeRunStatus status;
            TimingInfo times;
            FlowNode branchStartNode = this.nestedbranches.pop();
            FlowNode endNode = this.parallelBranchEndNodes.pop();
            if (endNode != null) {
                times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)this.chunk.getPauseTimeMillis(), (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)this.chunk.getNodeAfter());
                if (endNode instanceof StepAtomNode) {
                    status = PipelineNodeUtil.isPausedForInputStep((StepAtomNode)endNode, this.inputAction) ? new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED) : new NodeRunStatus(endNode);
                } else {
                    GenericStatus genericStatus = StatusAndTiming.computeChunkStatus((WorkflowRun)this.run, (FlowNode)parallelStartNode, (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)this.parallelEnd);
                    status = new NodeRunStatus(genericStatus);
                }
            } else {
                long startTime = System.currentTimeMillis();
                if (branchStartNode.getAction(TimingAction.class) != null) {
                    startTime = TimingAction.getStartTime((FlowNode)branchStartNode);
                }
                times = new TimingInfo(System.currentTimeMillis() - startTime, this.chunk.getPauseTimeMillis(), startTime);
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.RUNNING);
            }
            assert (times != null);
            FlowNodeWrapper branch = new FlowNodeWrapper(branchStartNode, status, times, this.run);
            if (this.nextStage != null) {
                branch.addEdge(this.nextStage.getId());
            }
            this.parallelBranches.push(branch);
        }
        FlowNodeWrapper[] sortedBranches = this.parallelBranches.toArray(new FlowNodeWrapper[this.parallelBranches.size()]);
        Arrays.sort(sortedBranches, new Comparator<FlowNodeWrapper>(){

            @Override
            public int compare(FlowNodeWrapper o1, FlowNodeWrapper o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.parallelBranches.clear();
        for (int i = 0; i < sortedBranches.length; ++i) {
            this.parallelBranches.push(sortedBranches[i]);
        }
        for (FlowNodeWrapper p : this.parallelBranches) {
            this.nodes.push(p);
            this.nodeMap.put(p.getId(), p);
        }
        this.parallelEnd = null;
    }

    public void parallelEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode parallelEndNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelEnd=> id: %s, name: %s, function: %s", parallelEndNode.getId(), parallelEndNode.getDisplayName(), parallelEndNode.getDisplayFunctionName()));
            if (parallelEndNode instanceof StepEndNode) {
                this.dump(String.format("parallelEnd=> id: %s, StartNode: %s, name: %s, function: %s", parallelEndNode.getId(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getId(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getDisplayName(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getDisplayFunctionName()));
            }
        }
        this.captureOrphanParallelBranches();
        this.parallelEnd = parallelEndNode;
    }

    public void parallelBranchStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchStartNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchStart=> id: %s, name: %s, function: %s", branchStartNode.getId(), branchStartNode.getDisplayName(), branchStartNode.getDisplayFunctionName()));
        }
        this.nestedbranches.push(branchStartNode);
    }

    public void parallelBranchEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchEndNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchEnd=> id: %s, name: %s, function: %s, type: %s", branchEndNode.getId(), branchEndNode.getDisplayName(), branchEndNode.getDisplayFunctionName(), branchEndNode.getClass()));
            if (branchEndNode instanceof StepEndNode) {
                this.dump(String.format("parallelBranchEnd=> id: %s, StartNode: %s, name: %s, function: %s", branchEndNode.getId(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getId(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getDisplayName(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getDisplayFunctionName()));
            }
        }
        this.parallelBranchEndNodes.add(branchEndNode);
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("atomNode=> id: %s, name: %s, function: %s, type: %s", atomNode.getId(), atomNode.getDisplayName(), atomNode.getDisplayFunctionName(), atomNode.getClass()));
        }
        if (atomNode instanceof FlowStartNode) {
            this.captureOrphanParallelBranches();
            return;
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)atomNode)) {
            this.firstExecuted = atomNode;
        }
        long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
        this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
        if (atomNode instanceof StepAtomNode && PipelineNodeUtil.isPausedForInputStep((StepAtomNode)atomNode, this.inputAction)) {
            this.pendingInputSteps.add(atomNode);
        }
    }

    private void dump(String str) {
        System.out.println(str);
    }

    @Override
    public List<FlowNodeWrapper> getPipelineNodes() {
        return new ArrayList<FlowNodeWrapper>(this.nodes);
    }

    @Override
    public List<BluePipelineNode> getPipelineNodes(Link parent) {
        ArrayList<BluePipelineNode> nodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : this.nodes) {
            nodes.add(new PipelineNodeImpl(n, parent, this.run));
        }
        return nodes;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(final String nodeId, Link parent) {
        FlowExecution execution = this.run.getExecution();
        if (execution == null) {
            logger.debug(String.format("Pipeline %s, runid %s  has null execution", ((WorkflowJob)this.run.getParent()).getName(), this.run.getId()));
            return Collections.emptyList();
        }
        DepthFirstScanner depthFirstScanner = new DepthFirstScanner();
        FlowNode n = depthFirstScanner.findFirstMatch((Collection)execution.getCurrentHeads(), (Predicate)new Predicate<FlowNode>(){

            public boolean apply(@Nullable FlowNode input) {
                return input != null && input.getId().equals(nodeId) && (PipelineNodeUtil.isStage(input) || PipelineNodeUtil.isParallelBranch(input));
            }
        });
        if (n == null) {
            return Collections.emptyList();
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, n);
        ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        ArrayList<BluePipelineStep> steps = new ArrayList<BluePipelineStep>();
        for (FlowNodeWrapper node : visitor.getSteps()) {
            steps.add(new PipelineStepImpl(node, parent));
        }
        return steps;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(Link parent) {
        FlowExecution execution = this.run.getExecution();
        if (execution == null) {
            return Collections.emptyList();
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, null);
        ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        ArrayList<BluePipelineStep> steps = new ArrayList<BluePipelineStep>();
        for (FlowNodeWrapper node : visitor.getSteps()) {
            steps.add(new PipelineStepImpl(node, parent));
        }
        return steps;
    }

    @Override
    public BluePipelineStep getPipelineNodeStep(String id, Link parent) {
        FlowExecution execution = this.run.getExecution();
        if (execution == null) {
            return null;
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, null);
        ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        FlowNodeWrapper node = visitor.getStep(id);
        if (node == null) {
            return null;
        }
        return new PipelineStepImpl(node, parent);
    }

    @Override
    public List<BluePipelineNode> union(List<FlowNodeWrapper> that, Link parent) {
        int futureNodeSize;
        ArrayList<FlowNodeWrapper> currentNodes = new ArrayList<FlowNodeWrapper>(this.nodes);
        int currentNodeSize = this.nodes.size();
        if (currentNodeSize < (futureNodeSize = that.size())) {
            for (int i = currentNodeSize; i < futureNodeSize; ++i) {
                FlowNodeWrapper futureNode = that.get(i);
                if (currentNodeSize > 0 && i == currentNodeSize) {
                    FlowNodeWrapper latestNode = (FlowNodeWrapper)currentNodes.get(i - 1);
                    if (latestNode.type == FlowNodeWrapper.NodeType.STAGE) {
                        FlowNodeWrapper thatStage;
                        if (futureNode.type == FlowNodeWrapper.NodeType.STAGE) {
                            latestNode.addEdge(futureNode.getId());
                        } else if (futureNode.type == FlowNodeWrapper.NodeType.PARALLEL && (thatStage = futureNode.getFirstParent()) != null && thatStage.equals(latestNode)) {
                            for (String edge : thatStage.edges) {
                                if (latestNode.edges.contains(edge)) continue;
                                latestNode.addEdge(edge);
                            }
                        }
                    } else if (latestNode.type == FlowNodeWrapper.NodeType.PARALLEL) {
                        String futureNodeId = null;
                        FlowNodeWrapper thatStage = null;
                        FlowNodeWrapper futureNodeParent = futureNode.getFirstParent();
                        if (futureNode.type == FlowNodeWrapper.NodeType.STAGE) {
                            thatStage = futureNode;
                            futureNodeId = futureNode.getId();
                        } else if (futureNode.type == FlowNodeWrapper.NodeType.PARALLEL && futureNodeParent != null && futureNodeParent.equals(latestNode.getFirstParent())) {
                            thatStage = futureNode.getFirstParent();
                            if (futureNode.edges.size() > 0) {
                                futureNodeId = futureNode.edges.get(0);
                            }
                        }
                        FlowNodeWrapper stage = latestNode.getFirstParent();
                        if (stage != null) {
                            for (String id : stage.edges) {
                                FlowNodeWrapper node = this.nodeMap.get(id);
                                if (node == null || futureNodeId == null) continue;
                                node.addEdge(futureNodeId);
                            }
                            if (thatStage != null && futureNode.type == FlowNodeWrapper.NodeType.PARALLEL) {
                                for (String edge : thatStage.edges) {
                                    if (stage.edges.contains(edge)) continue;
                                    stage.addEdge(edge);
                                }
                            }
                        }
                    }
                }
                FlowNodeWrapper n = new FlowNodeWrapper(futureNode.getNode(), new NodeRunStatus(null, null), new TimingInfo(), this.run);
                n.addEdges(futureNode.edges);
                n.addParents(futureNode.getParents());
                currentNodes.add(n);
            }
        }
        ArrayList<BluePipelineNode> newNodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : currentNodes) {
            newNodes.add(new PipelineNodeImpl(n, parent, this.run));
        }
        return newNodes;
    }

    private void captureOrphanParallelBranches() {
        FlowNodeWrapper synStage;
        if (!(this.parallelBranches.isEmpty() || this.firstExecuted != null && PipelineNodeUtil.isStage(this.firstExecuted) || (synStage = this.createParallelSyntheticNode()) == null)) {
            this.nodes.push(synStage);
            this.nodeMap.put(synStage.getId(), synStage);
            this.parallelBranches.clear();
            this.nextStage = synStage;
        }
    }

    @Nullable
    private FlowNodeWrapper createParallelSyntheticNode() {
        BlueRun.BlueRunState state;
        if (this.parallelBranches.isEmpty()) {
            return null;
        }
        FlowNodeWrapper firstBranch = this.parallelBranches.getLast();
        FlowNodeWrapper parallel = firstBranch.getFirstParent();
        String firstNodeId = firstBranch.getId();
        ArrayList parents = parallel != null ? parallel.getNode().getParents() : new ArrayList();
        FlowNode syntheticNode = new FlowNode(firstBranch.getNode().getExecution(), this.createSyntheticStageId(firstNodeId, PARALLEL_SYNTHETIC_STAGE_NAME), parents){

            protected String getTypeDisplayName() {
                return PipelineNodeGraphVisitor.PARALLEL_SYNTHETIC_STAGE_NAME;
            }
        };
        syntheticNode.addAction((Action)new LabelAction(PARALLEL_SYNTHETIC_STAGE_NAME));
        long duration = 0L;
        long pauseDuration = 0L;
        long startTime = System.currentTimeMillis();
        boolean isCompleted = true;
        boolean isPaused = false;
        boolean isFailure = false;
        boolean isUnknown = false;
        for (FlowNodeWrapper pb : this.parallelBranches) {
            if (!isPaused && pb.getStatus().getState() == BlueRun.BlueRunState.PAUSED) {
                isPaused = true;
            }
            if (isCompleted && pb.getStatus().getState() != BlueRun.BlueRunState.FINISHED) {
                isCompleted = false;
            }
            if (!isFailure && pb.getStatus().getResult() == BlueRun.BlueRunResult.FAILURE) {
                isFailure = true;
            }
            if (!isUnknown && pb.getStatus().getResult() == BlueRun.BlueRunResult.UNKNOWN) {
                isUnknown = true;
            }
            duration += pb.getTiming().getTotalDurationMillis();
            pauseDuration += pb.getTiming().getPauseDurationMillis();
        }
        BlueRun.BlueRunState blueRunState = isCompleted ? BlueRun.BlueRunState.FINISHED : (state = isPaused ? BlueRun.BlueRunState.PAUSED : BlueRun.BlueRunState.RUNNING);
        BlueRun.BlueRunResult result = isFailure ? BlueRun.BlueRunResult.FAILURE : (isUnknown ? BlueRun.BlueRunResult.UNKNOWN : BlueRun.BlueRunResult.SUCCESS);
        TimingInfo timingInfo = new TimingInfo(duration, pauseDuration, startTime);
        FlowNodeWrapper synStage = new FlowNodeWrapper(syntheticNode, new NodeRunStatus(result, state), timingInfo, this.run);
        Iterator<FlowNodeWrapper> sortedBranches = this.parallelBranches.descendingIterator();
        while (sortedBranches.hasNext()) {
            FlowNodeWrapper p = sortedBranches.next();
            p.addParent(synStage);
            synStage.addEdge(p.getId());
        }
        return synStage;
    }

    @Nonnull
    private String createSyntheticStageId(@Nonnull String firstNodeId, @Nonnull String syntheticStageName) {
        return String.format("%s-%s-synthetic", firstNodeId, syntheticStageName.toLowerCase());
    }
}

