/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.CreateResponse;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.POST;

public class CredentialApi
extends Resource {
    private final CredentialsStoreAction credentialStoreAction;
    private final Reachable parent;

    public CredentialApi(CredentialsStoreAction ca, Reachable parent) {
        this.credentialStoreAction = ca;
        this.parent = parent;
    }

    @Exported
    public String getStore() {
        return this.credentialStoreAction.getUrlName();
    }

    @Navigable
    public Container<CredentialDomain> getDomains() {
        return new Container<CredentialDomain>(){
            private final Link self;
            Map<String, CredentialsStoreAction.DomainWrapper> map;
            {
                this.self = CredentialApi.this.getLink().rel("domains");
                this.map = CredentialApi.this.credentialStoreAction.getDomains();
            }

            public CredentialDomain get(String name) {
                return new CredentialDomain(this.map.get(name), this.getLink());
            }

            public Link getLink() {
                return this.self;
            }

            public Iterator<CredentialDomain> iterator() {
                final Iterator<CredentialsStoreAction.DomainWrapper> i = this.map.values().iterator();
                return new Iterator<CredentialDomain>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public CredentialDomain next() {
                        return new CredentialDomain((CredentialsStoreAction.DomainWrapper)i.next(), this.getLink());
                    }

                    @Override
                    public void remove() {
                        throw new ServiceException.NotImplementedException("Not implemented yet");
                    }
                };
            }
        };
    }

    public Link getLink() {
        return this.parent.getLink().rel(this.getStore());
    }

    public static class Credential
    extends Resource {
        private final Link self;
        private final CredentialsStoreAction.CredentialsWrapper credentialsWrapper;

        public Credential(CredentialsStoreAction.CredentialsWrapper credentialsWrapper, Link parent) {
            this.self = parent.rel(credentialsWrapper.getUrlName());
            this.credentialsWrapper = credentialsWrapper;
        }

        @Exported(merge=true, inline=true)
        public CredentialsStoreAction.CredentialsWrapper getCredential() {
            return this.credentialsWrapper;
        }

        public Link getLink() {
            return this.self;
        }

        @Exported
        public String getDomain() {
            return this.credentialsWrapper.getDomain().getUrlName();
        }

        @Exported
        public String getDescription() {
            if (this.credentialsWrapper.getDescription() == null || this.credentialsWrapper.getDescription().trim().isEmpty()) {
                return String.format("%s:%s:%s", this.credentialsWrapper.getDisplayName(), this.credentialsWrapper.getDomain().getUrlName(), this.credentialsWrapper.getTypeName());
            }
            return this.credentialsWrapper.getDescription();
        }
    }

    public static class CredentialValueContainer
    extends Container<Credential> {
        private final CredentialsStoreAction.DomainWrapper domainWrapper;
        private final Link self;

        public CredentialValueContainer(CredentialsStoreAction.DomainWrapper domainWrapper, Reachable parent) {
            this.domainWrapper = domainWrapper;
            this.self = parent.getLink().rel("credentials");
        }

        public Credential get(String name) {
            return new Credential(this.domainWrapper.getCredential(name), this.self);
        }

        @POST
        @WebMethod(name={""})
        public CreateResponse create(@JsonBody JSONObject body, StaplerRequest request) throws IOException {
            IdCredentials credentials = (IdCredentials)request.bindJSON(IdCredentials.class, body.getJSONObject("credentials"));
            this.domainWrapper.getStore().addCredentials(this.domainWrapper.getDomain(), (Credentials)credentials);
            Domain domain = this.domainWrapper.getDomain();
            this.domainWrapper.getStore().addCredentials(domain, (Credentials)credentials);
            return new CreateResponse((Reachable)new Credential((CredentialsStoreAction.CredentialsWrapper)this.domainWrapper.getCredentials().get(credentials.getId()), this.getLink()));
        }

        public Link getLink() {
            return this.self;
        }

        public Iterator<Credential> iterator() {
            final Iterator i = this.domainWrapper.getCredentialsList().iterator();
            return new Iterator<Credential>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public Credential next() {
                    return new Credential((CredentialsStoreAction.CredentialsWrapper)i.next(), CredentialValueContainer.this.self);
                }

                @Override
                public void remove() {
                    throw new ServiceException.NotImplementedException("Not implemented yet");
                }
            };
        }
    }

    public static class CredentialDomain
    extends Resource {
        private final Link self;
        private final CredentialsStoreAction.DomainWrapper domainWrapper;

        public CredentialDomain(CredentialsStoreAction.DomainWrapper domainWrapper, Link parent) {
            this.self = parent.rel(domainWrapper.getUrlName());
            this.domainWrapper = domainWrapper;
        }

        @Exported(inline=true, merge=true)
        public CredentialsStoreAction.DomainWrapper getDomain() {
            return this.domainWrapper;
        }

        public Link getLink() {
            return this.self;
        }

        @Navigable
        public CredentialValueContainer getCredentials() {
            return new CredentialValueContainer(this.domainWrapper, (Reachable)this);
        }
    }
}

