/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;

public class FlowNodeWrapper {
    private final FlowNode node;
    private final NodeRunStatus status;
    private final TimingInfo timingInfo;
    public final List<String> edges = new ArrayList<String>();
    public final NodeType type;
    private final String displayName;
    private final InputStep inputStep;
    private final WorkflowRun run;
    private String causeOfFailure;
    private List<FlowNodeWrapper> parents = new ArrayList<FlowNodeWrapper>();
    private ErrorAction blockErrorAction;

    public FlowNodeWrapper(@Nonnull FlowNode node, @Nonnull NodeRunStatus status, @Nonnull TimingInfo timingInfo, @Nonnull WorkflowRun run) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = FlowNodeWrapper.getNodeType(node);
        this.displayName = PipelineNodeUtil.getDisplayName(node);
        this.inputStep = null;
        this.run = run;
    }

    public FlowNodeWrapper(@Nonnull FlowNode node, @Nonnull NodeRunStatus status, @Nonnull TimingInfo timingInfo, @Nullable InputStep inputStep, @Nonnull WorkflowRun run) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = FlowNodeWrapper.getNodeType(node);
        this.displayName = PipelineNodeUtil.getDisplayName(node);
        this.inputStep = inputStep;
        this.run = run;
    }

    public WorkflowRun getRun() {
        return this.run;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    private static NodeType getNodeType(FlowNode node) {
        if (PipelineNodeUtil.isStage(node)) {
            return NodeType.STAGE;
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return NodeType.PARALLEL;
        }
        if (node instanceof AtomNode) {
            return NodeType.STEP;
        }
        throw new IllegalArgumentException(String.format("Unknown FlowNode %s, type: %s", node.getId(), node.getClass()));
    }

    @Nonnull
    public NodeRunStatus getStatus() {
        return this.status;
    }

    @Nonnull
    public TimingInfo getTiming() {
        return this.timingInfo;
    }

    @Nonnull
    public String getId() {
        return this.node.getId();
    }

    @Nonnull
    public FlowNode getNode() {
        return this.node;
    }

    public void addEdge(String id) {
        this.edges.add(id);
    }

    public void addEdges(List<String> edges) {
        this.edges.addAll(edges);
    }

    public void addParent(FlowNodeWrapper parent) {
        this.parents.add(parent);
    }

    public void addParents(Collection<FlowNodeWrapper> parents) {
        parents.addAll(parents);
    }

    @CheckForNull
    public FlowNodeWrapper getFirstParent() {
        return this.parents.size() > 0 ? this.parents.get(0) : null;
    }

    @Nonnull
    public List<FlowNodeWrapper> getParents() {
        return this.parents;
    }

    public String getCauseOfFailure() {
        return this.causeOfFailure;
    }

    public void setCauseOfFailure(String causeOfFailure) {
        this.causeOfFailure = causeOfFailure;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowNodeWrapper)) {
            return false;
        }
        return this.node.equals((Object)((FlowNodeWrapper)obj).node);
    }

    @CheckForNull
    public InputStep getInputStep() {
        return this.inputStep;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public ErrorAction getBlockErrorAction() {
        return this.blockErrorAction;
    }

    public void setBlockErrorAction(ErrorAction blockErrorAction) {
        this.blockErrorAction = blockErrorAction;
    }

    public static enum NodeType {
        STAGE,
        PARALLEL,
        STEP;

    }
}

