/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Job;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.actions.ChangeRequestAction;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueBranch", "org.jenkinsci.plugins.workflow.job.WorkflowJob", "io.jenkins.blueocean.rest.model.PullRequest"})
public class BranchImpl
extends PipelineImpl {
    private static final String PULL_REQUEST = "pullRequest";
    private final Link parent;
    protected final Job job;

    public BranchImpl(Job job, Link parent) {
        super(job);
        this.job = job;
        this.parent = parent;
    }

    @Exported(name="pullRequest", inline=true)
    public PullRequest getPullRequest() {
        ChangeRequestAction action;
        SCMHead head = SCMHead.HeadByItem.findHead((Item)this.job);
        if (head != null && (action = (ChangeRequestAction)head.getAction(ChangeRequestAction.class)) != null) {
            return new PullRequest(action.getId(), action.getURL().toExternalForm(), action.getTitle(), action.getAuthor());
        }
        return null;
    }

    public Link getLink() {
        return this.parent.rel(Util.rawEncode((String)this.getName()));
    }

    public static class PullRequest
    extends Resource {
        private static final String PULL_REQUEST_NUMBER = "id";
        private static final String PULL_REQUEST_AUTHOR = "author";
        private static final String PULL_REQUEST_TITLE = "title";
        private static final String PULL_REQUEST_URL = "url";
        private final String id;
        private final String url;
        private final String title;
        private final String author;

        public PullRequest(String id, String url, String title, String author) {
            this.id = id;
            this.url = url;
            this.title = title;
            this.author = author;
        }

        @Exported(name="id")
        public String getId() {
            return this.id;
        }

        @Exported(name="url")
        public String getUrl() {
            return this.url;
        }

        @Exported(name="title")
        public String getTitle() {
            return this.title;
        }

        @Exported(name="author")
        public String getAuthor() {
            return this.author;
        }

        public Link getLink() {
            return null;
        }
    }

    @Extension(ordinal=4.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent) {
            if (item instanceof WorkflowJob && item.getParent() instanceof MultiBranchProject) {
                return new BranchImpl((Job)item, parent.getLink());
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target) {
            if (context == target.getParent()) {
                return this.getPipeline(context, parent);
            }
            return null;
        }
    }
}

