/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineNodeImpl
extends BluePipelineNode {
    private final FlowNode node;
    private final List<FlowNode> children;
    private final List<BluePipelineNode.Edge> edges;
    private final WorkflowRun run;
    private final Long durationInMillis;
    private final PipelineNodeGraphBuilder.NodeRunStatus status;
    private final PipelineNodeGraphBuilder nodeGraphBuilder;
    private final Link self;

    public PipelineNodeImpl(WorkflowRun run, FlowNode node, PipelineNodeGraphBuilder.NodeRunStatus status, PipelineNodeGraphBuilder nodeGraphBuilder, Link parentLink) {
        this.run = run;
        this.node = node;
        this.children = nodeGraphBuilder.getChildren(node);
        this.edges = this.buildEdges();
        this.status = status;
        this.durationInMillis = this.getStateObj() == BlueRun.BlueRunState.FINISHED ? nodeGraphBuilder.getDurationInMillis(node) : (this.getStateObj() == BlueRun.BlueRunState.RUNNING ? Long.valueOf(System.currentTimeMillis() - TimingAction.getStartTime((FlowNode)node)) : null);
        this.nodeGraphBuilder = nodeGraphBuilder;
        this.self = parentLink.rel(node.getId());
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node);
    }

    public BlueRun.BlueRunResult getResult() {
        if (this.isInactiveNode()) {
            return null;
        }
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        if (this.isInactiveNode()) {
            return null;
        }
        return this.status.getState();
    }

    public Date getStartTime() {
        if (this.isInactiveNode()) {
            return null;
        }
        long nodeTime = TimingAction.getStartTime((FlowNode)this.node);
        return new Date(nodeTime);
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.nodeGraphBuilder, this.self);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        return PipelineImpl.getActionProxies((List)this.node.getAllActions(), (Reachable)this);
    }

    private List<BluePipelineNode.Edge> buildEdges() {
        ArrayList<BluePipelineNode.Edge> edges = new ArrayList<BluePipelineNode.Edge>();
        if (!this.children.isEmpty()) {
            for (FlowNode c : this.children) {
                edges.add(new EdgeImpl(this.node, c));
            }
        }
        return edges;
    }

    private boolean isInactiveNode() {
        return this.node instanceof PipelineNodeGraphBuilder.InactiveFlowNodeWrapper;
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final FlowNode node;
        private final FlowNode edge;

        public EdgeImpl(FlowNode node, FlowNode edge) {
            this.node = node;
            this.edge = edge;
        }

        public String getId() {
            return this.edge.getId();
        }
    }
}

