/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class PipelineStepImpl
extends BluePipelineStep {
    private final FlowNode node;
    private final PipelineNodeGraphBuilder.NodeRunStatus status;
    private final Long durationInMillis;
    private final Link self;

    public PipelineStepImpl(FlowNode node, PipelineNodeGraphBuilder graphBuilder, Link parent) {
        assert (graphBuilder != null);
        assert (node != null);
        this.self = parent.rel(node.getId());
        this.node = node;
        this.status = new PipelineNodeGraphBuilder.NodeRunStatus(node);
        this.durationInMillis = graphBuilder.getDurationInMillis(node);
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    public Date getStartTime() {
        return new Date(TimingAction.getStartTime((FlowNode)this.node));
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        if (PipelineNodeUtil.isLoggable.apply((Object)this.node)) {
            return new LogResource(((LogAction)this.node.getAction(LogAction.class)).getLogText());
        }
        return null;
    }

    public Collection<BlueActionProxy> getActions() {
        return PipelineImpl.getActionProxies((List)this.node.getActions(), (Reachable)this);
    }

    public Link getLink() {
        return this.self;
    }
}

