/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepImpl;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class PipelineStepContainerImpl
extends BluePipelineStepContainer {
    private final FlowNode node;
    private final PipelineNodeGraphBuilder graphBuilder;
    private final Link self;

    public PipelineStepContainerImpl(FlowNode node, PipelineNodeGraphBuilder graphBuilder, Link parentLink) {
        this.self = parentLink.rel("steps");
        this.node = node;
        this.graphBuilder = graphBuilder;
    }

    public BluePipelineStep get(String name) {
        FlowNode node = this.graphBuilder.getNodeById(name);
        if (node == null) {
            throw new ServiceException.NotFoundException(String.format("Node %s is not found", name));
        }
        if (!(node instanceof StepAtomNode)) {
            throw new ServiceException.BadRequestExpception(String.format("Node %s:%s is not a step node.", name, node.getDisplayName()));
        }
        return new PipelineStepImpl(node, this.graphBuilder, this.getLink());
    }

    public Iterator<BluePipelineStep> iterator() {
        ArrayList<PipelineStepImpl> pipelineSteps = new ArrayList<PipelineStepImpl>();
        if (this.node != null) {
            List<FlowNode> nodes = this.graphBuilder.getSteps(this.node);
            for (FlowNode node : nodes) {
                pipelineSteps.add(new PipelineStepImpl(node, this.graphBuilder, this.getLink()));
            }
        } else {
            List<FlowNode> nodes = this.graphBuilder.getAllSteps();
            for (FlowNode node : nodes) {
                pipelineSteps.add(new PipelineStepImpl(node, this.graphBuilder, this.getLink()));
            }
        }
        return pipelineSteps.iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

