/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueRunFactory;
import io.jenkins.blueocean.service.embedded.rest.ChangeSetResource;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.LinkedHashMap;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"org.jenkinsci.plugins.workflow.job.WorkflowRun"})
public class PipelineRunImpl
extends AbstractRunImpl<WorkflowRun> {
    public PipelineRunImpl(WorkflowRun run, Link parent) {
        super((Run)run, parent);
    }

    public Container<BlueChangeSetEntry> getChangeSet() {
        LinkedHashMap<String, ChangeSetResource> m = new LinkedHashMap<String, ChangeSetResource>();
        int cnt = 0;
        for (ChangeLogSet cs : ((WorkflowRun)this.run).getChangeSets()) {
            for (ChangeLogSet.Entry e : cs) {
                ++cnt;
                String id = e.getCommitId();
                if (id == null) {
                    id = String.valueOf(cnt);
                }
                m.put(id, new ChangeSetResource(e, (Reachable)this));
            }
        }
        return Containers.fromResourceMap((Link)this.getLink(), m);
    }

    public BlueQueueItem replay() {
        ReplayAction replayAction = (ReplayAction)((WorkflowRun)this.run).getAction(ReplayAction.class);
        if (replayAction == null) {
            throw new ServiceException.BadRequestExpception("This run does not support replay");
        }
        Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
        BlueQueueItem queueItem = QueueContainerImpl.getQueuedItem((Queue.Item)item, (Job)((WorkflowRun)this.run).getParent());
        if (queueItem == null) {
            throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
        }
        return queueItem;
    }

    public BluePipelineNodeContainer getNodes() {
        if (this.run != null) {
            return new PipelineNodeContainerImpl((WorkflowRun)this.run, this.getLink());
        }
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(null, new PipelineNodeGraphBuilder((WorkflowRun)this.run), this.getLink());
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        return this.stop(blocking, timeOutInSecs, new StoppableRun(){

            public void stop() {
                ((WorkflowRun)PipelineRunImpl.this.run).doStop();
            }
        });
    }

    @Exported(name="commitId")
    public String getCommitId() {
        BuildData data = (BuildData)((WorkflowRun)this.run).getAction(BuildData.class);
        if (data == null || data.getLastBuiltRevision() == null || data.getLastBuiltRevision().getSha1String() == null) {
            return null;
        }
        return data.getLastBuiltRevision().getSha1String();
    }

    @Extension(ordinal=1.0)
    public static class FactoryImpl
    extends BlueRunFactory {
        public BlueRun getRun(Run run, Reachable parent) {
            if (run instanceof WorkflowRun) {
                return new PipelineRunImpl((WorkflowRun)run, parent.getLink());
            }
            return null;
        }
    }
}

