/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.collect.Lists;
import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.model.Jenkins;

public class MultiBranchPipelineQueueContainer
extends BlueQueueContainer {
    private final MultiBranchPipelineImpl multiBranchPipeline;
    private final Link self;

    public MultiBranchPipelineQueueContainer(MultiBranchPipelineImpl multiBranchPipeline) {
        this.multiBranchPipeline = multiBranchPipeline;
        this.self = multiBranchPipeline.getLink().rel("queue");
    }

    public BlueQueueItem get(String name) {
        try {
            Job job;
            Queue.Item item = Jenkins.getInstance().getQueue().getItem(Long.parseLong(name));
            if (item != null && item.task instanceof Job && (job = (Job)item.task).getParent() != null && job.getParent().getFullName().equals(this.multiBranchPipeline.mbp.getFullName())) {
                return QueueContainerImpl.getQueuedItem((Queue.Item)item, (Job)job);
            }
        }
        catch (NumberFormatException e) {
            throw new ServiceException.BadRequestExpception("Invalid queue id: " + name + ". Must be a number.", (Throwable)e);
        }
        return null;
    }

    public Link getLink() {
        return this.self;
    }

    public Iterator<BlueQueueItem> iterator() {
        ArrayList queueItems = Lists.newArrayList();
        for (Object o : this.multiBranchPipeline.mbp.getItems()) {
            if (!(o instanceof Job)) continue;
            queueItems.addAll(QueueContainerImpl.getQueuedItems((Job)((Job)o)));
        }
        return queueItems.iterator();
    }
}

