/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Job;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BranchContainerImpl
extends BluePipelineContainer {
    private final MultiBranchPipelineImpl pipeline;
    private final Link self;

    public BranchContainerImpl(MultiBranchPipelineImpl pipeline, Link self) {
        this.pipeline = pipeline;
        this.self = self;
    }

    public BluePipeline get(String name) {
        Job job = this.pipeline.mbp.getBranch(name);
        if (job != null) {
            return new BranchImpl(job, this.getLink());
        }
        return null;
    }

    public Iterator<BluePipeline> iterator() {
        ArrayList<BranchImpl> branches = new ArrayList<BranchImpl>();
        Collection jobs = this.pipeline.mbp.getAllJobs();
        jobs = ContainerFilter.filter((Collection)jobs);
        for (Job j : jobs) {
            branches.add(new BranchImpl(j, this.getLink()));
        }
        return branches.iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

