/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import hudson.Extension;
import hudson.model.Job;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.model.BlueIssue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.HttpsRepositoryUriResolver;

public class GithubIssue
extends BlueIssue {
    private static final Pattern PATTERN = Pattern.compile("((?:[\\w-.]+\\/[\\w-.]+)?#[1-9]\\d*)");
    private final String id;
    private final String url;

    public GithubIssue(String id, String url) {
        this.id = id;
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public String getURL() {
        return this.url;
    }

    static Collection<String> findIssueKeys(String input) {
        ArrayList<String> ids = new ArrayList<String>();
        Matcher m = PATTERN.matcher(input);
        while (m.find()) {
            if (m.groupCount() < 1) continue;
            String issue = m.group(1);
            ids.add(issue.substring(1, issue.length()));
        }
        return ids;
    }

    @Extension
    public static class FactoryImpl
    extends BlueIssueFactory {
        public Collection<BlueIssue> getIssues(Job job) {
            return null;
        }

        public Collection<BlueIssue> getIssues(ChangeLogSet.Entry changeSetEntry) {
            SCMSource source;
            Job job = changeSetEntry.getParent().getRun().getParent();
            if (!(job.getParent() instanceof MultiBranchProject)) {
                return null;
            }
            MultiBranchProject mbp = (MultiBranchProject)job.getParent();
            List scmSources = mbp.getSCMSources();
            SCMSource sCMSource = source = scmSources.isEmpty() ? null : (SCMSource)scmSources.get(0);
            if (source == null || !(source instanceof GitHubSCMSource)) {
                return null;
            }
            GitHubSCMSource gitHubSource = (GitHubSCMSource)source;
            String url = gitHubSource.getApiUri();
            String apiUri = url == null ? "https://api.github.com" : url;
            String repositoryUri = new HttpsRepositoryUriResolver().getRepositoryUri(apiUri, gitHubSource.getRepoOwner(), gitHubSource.getRepository());
            ArrayList<BlueIssue> results = new ArrayList<BlueIssue>();
            for (String input : GithubIssue.findIssueKeys(changeSetEntry.getMsg())) {
                String uri = repositoryUri.substring(0, repositoryUri.length() - 4);
                results.add(new GithubIssue("#" + input, String.format("%s/issues/%s", uri, input)));
            }
            return results;
        }
    }
}

