/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import hudson.ProxyConfiguration;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import jenkins.model.Jenkins;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.extras.OkHttpConnector;

class GitHubFactory {
    public static GitHub connect(String accessToken, String endpointUri) throws IOException {
        URL apiUrl = new URL(endpointUri);
        ProxyConfiguration proxyConfig = Jenkins.getInstance().proxy;
        Proxy proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(apiUrl.getHost());
        OkHttpClient client = new OkHttpClient().setProxy(proxy);
        return new GitHubBuilder().withOAuthToken(accessToken).withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(client))).withRateLimitHandler((RateLimitHandler)RateLimitHandlerImpl.INSTANCE).withAbuseLimitHandler((AbuseLimitHandler)AbuseLimitHandlerImpl.INSTANCE).withProxy(proxy).withEndpoint(endpointUri).build();
    }

    private GitHubFactory() {
    }

    static class AbuseLimitHandlerImpl
    extends AbuseLimitHandler {
        static final AbuseLimitHandlerImpl INSTANCE = new AbuseLimitHandlerImpl();

        AbuseLimitHandlerImpl() {
        }

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            throw new ServiceException.BadRequestException("API abuse limit reached. Message: " + e.getMessage(), (Throwable)e);
        }
    }

    static class RateLimitHandlerImpl
    extends RateLimitHandler {
        static final RateLimitHandlerImpl INSTANCE = new RateLimitHandlerImpl();

        RateLimitHandlerImpl() {
        }

        public void onError(IOException e, HttpURLConnection httpURLConnection) throws IOException {
            throw new ServiceException.BadRequestException("API rate limit reached. Message: " + e.getMessage(), (Throwable)e);
        }
    }
}

