/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.google.common.collect.Iterables;
import hudson.Extension;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.OrganizationFolderPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.HashMap;
import java.util.Map;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class GithubOrganizationFolder
extends OrganizationFolderPipelineImpl {
    private final Map<String, BlueRepositoryProperty> repos = new HashMap<String, BlueRepositoryProperty>();

    public GithubOrganizationFolder(BlueOrganization organization, OrganizationFolder folder, Link parent) {
        super(organization, folder, parent);
    }

    public boolean isScanAllRepos() {
        SCMNavigator scmNavigator;
        if (!this.getFolder().getSCMNavigators().isEmpty() && (scmNavigator = (SCMNavigator)this.getFolder().getSCMNavigators().get(0)) instanceof GitHubSCMNavigator) {
            GitHubSCMNavigator gitHubSCMNavigator = (GitHubSCMNavigator)scmNavigator;
            return !(!StringUtils.isBlank((CharSequence)gitHubSCMNavigator.getIncludes()) && !gitHubSCMNavigator.getIncludes().equals("*") || !StringUtils.isBlank((CharSequence)gitHubSCMNavigator.getExcludes()) || !StringUtils.isBlank((CharSequence)gitHubSCMNavigator.getPattern()) && !gitHubSCMNavigator.getPattern().equals(".*"));
        }
        return super.isScanAllRepos();
    }

    @Exported(name="repos")
    public Map<String, BlueRepositoryProperty> repos() {
        return this.repos;
    }

    void addRepo(String repo, BlueRepositoryProperty prop) {
        this.repos.put(repo, prop);
    }

    @ExportedBean(defaultVisibility=9999)
    public static abstract class BlueRepositoryProperty {
        @Exported(name="meetsScanCriteria")
        public abstract boolean meetsIndexingCriteria();
    }

    @Extension(ordinal=-8.0)
    public static class OrganizationFolderFactoryImpl
    extends OrganizationFolderPipelineImpl.OrganizationFolderFactory {
        protected OrganizationFolderPipelineImpl getFolder(OrganizationFolder folder, Reachable parent, BlueOrganization organization) {
            SCMNavigator navigator = (SCMNavigator)Iterables.getFirst((Iterable)folder.getNavigators(), null);
            return GitHubSCMNavigator.class.isInstance(navigator) ? new GithubOrganizationFolder(organization, folder, parent.getLink()) : null;
        }
    }
}

