/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;
import org.parboiled.common.StringUtils;

public class GithubEnterpriseScm
extends GithubScm {
    static final String ID = "github-enterprise";
    static final String DOMAIN_NAME = "blueocean-github-enterprise-domain";
    static final String CREDENTIAL_DESCRIPTION = "GitHub Enterprise Access Token";

    public GithubEnterpriseScm(Reachable parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public String getId() {
        return ID;
    }

    @Override
    @Nonnull
    public String getUri() {
        String apiUri = this.getCustomApiUri();
        if (StringUtils.isEmpty((String)apiUri)) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "apiUrl is required parameter"));
        }
        return apiUri;
    }

    @Override
    public String getCredentialId() {
        String credentialId = this.createCredentialId(this.getUri());
        StandardUsernamePasswordCredentials githubCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (githubCredential != null) {
            return githubCredential.getId();
        }
        return null;
    }

    @Override
    public String getCredentialDomainName() {
        return DOMAIN_NAME;
    }

    @WebMethod(name={""})
    @GET
    @TreeResponse
    public Object getState() {
        this.getUri();
        return this;
    }

    @Override
    @Nonnull
    protected String createCredentialId(@Nonnull String apiUri) {
        return this.getId() + ":" + DigestUtils.sha256Hex((String)apiUri);
    }

    @Override
    @Nonnull
    protected String getCredentialDescription() {
        return CREDENTIAL_DESCRIPTION;
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(String id, Reachable parent) {
            if (id.equals(GithubEnterpriseScm.ID)) {
                return new GithubEnterpriseScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GithubEnterpriseScm(parent);
        }
    }
}

