/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.google.common.collect.ImmutableMap;
import io.jenkins.blueocean.blueocean_github_pipeline.GHRepoEx;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubContent;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubFile;
import io.jenkins.blueocean.blueocean_github_pipeline.HttpRequest;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHContent;
import org.kohsuke.stapler.DataBoundConstructor;

public class GithubScmSaveFileRequest {
    private final GithubContent content;

    @DataBoundConstructor
    public GithubScmSaveFileRequest(GithubContent content) {
        this.content = content;
    }

    public Object save(@Nonnull String apiUrl, @Nullable String owner, @Nullable String repoName, @Nullable String accessToken) {
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        if (this.content == null) {
            errors.add(new ErrorMessage.Error("content", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "content is required parameter"));
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to save file to scm").addAll(errors));
        }
        errors.addAll(this.content.validate());
        if (owner == null) {
            owner = this.content.getOwner();
        }
        if (repoName == null) {
            repoName = this.content.getRepo();
        }
        if (owner == null) {
            errors.add(new ErrorMessage.Error("content.owner", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "No scm owner found with pipeline %s, please provide content.owner parameter"));
        }
        if (repoName == null) {
            errors.add(new ErrorMessage.Error("content.repo", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "No scm repo found with pipeline %s, please provide content.repo parameter"));
        }
        if (errors.size() > 0) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to save content").addAll(errors));
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to save file to scm").addAll(errors));
        }
        try {
            Map ghResp;
            String sha = this.createBranchIfNotPresent(apiUrl, owner, repoName, accessToken);
            if (!StringUtils.isBlank((CharSequence)this.content.getSha())) {
                sha = this.content.getSha();
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("message", this.content.getMessage());
            body.put("content", this.content.getBase64Data());
            if (!StringUtils.isBlank((CharSequence)this.content.getBranch())) {
                body.put("branch", this.content.getBranch());
            }
            if (!StringUtils.isBlank((CharSequence)sha)) {
                body.put("sha", sha);
            }
            if ((ghResp = HttpRequest.put(String.format("%s/repos/%s/%s/contents/%s", apiUrl, owner, repoName, this.content.getPath())).withAuthorization("token " + accessToken).withBody(body).to(Map.class)) == null) {
                throw new ServiceException.UnexpectedErrorException("Failed to save file to Github: " + this.content.getPath());
            }
            Map ghContent = (Map)ghResp.get("content");
            if (ghContent == null) {
                throw new ServiceException.UnexpectedErrorException("Failed to save file: " + this.content.getPath());
            }
            return new GithubFile(new GithubContent.Builder().sha((String)ghContent.get("sha")).name((String)ghContent.get("name")).repo(repoName).owner(owner).path((String)ghContent.get("path")).build());
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to save file: " + e.getMessage(), (Throwable)e);
        }
    }

    private String createBranchIfNotPresent(String apiUrl, String owner, String repoName, String accessToken) throws IOException {
        block8: {
            if (StringUtils.isBlank((CharSequence)this.content.getBranch()) || this.content.isAutoCreateBranch() != null && !this.content.isAutoCreateBranch().booleanValue()) {
                return null;
            }
            if (this.isEmptyRepo(apiUrl, owner, repoName, accessToken)) {
                return null;
            }
            try {
                HttpRequest.head(String.format("%s/repos/%s/%s/branches/%s", apiUrl, owner, repoName, this.content.getBranch())).withAuthorization("token " + accessToken).to(String.class);
            }
            catch (ServiceException.NotFoundException e) {
                String sha = this.content.getSha();
                GHRepoEx repo = HttpRequest.get(String.format("%s/repos/%s/%s", apiUrl, owner, repoName)).withAuthorization("token " + accessToken).to(GHRepoEx.class);
                String sourceBranch = this.content.getSourceBranch();
                if (sourceBranch == null) {
                    sourceBranch = repo.getDefaultBranch();
                }
                GHBranch branch = HttpRequest.get(String.format("%s/repos/%s/%s/branches/%s", apiUrl, owner, repoName, sourceBranch)).withAuthorization("token " + accessToken).to(GHBranch.class);
                HttpRequest.post(String.format("%s/repos/%s/%s/git/refs", apiUrl, owner, repoName)).withAuthorization("token " + accessToken).withBody(ImmutableMap.of((Object)"ref", (Object)("refs/heads/" + this.content.getBranch()), (Object)"sha", (Object)branch.getSHA1())).to(Map.class);
                if (!StringUtils.isBlank((CharSequence)this.content.getSha())) break block8;
                try {
                    GHContent ghContent = HttpRequest.get(String.format("%s/repos/%s/%s/contents/%s", apiUrl, owner, repoName, this.content.getPath())).withAuthorization("token " + accessToken).to(GHContent.class);
                    if (!StringUtils.isBlank((CharSequence)sha) && !sha.equals(ghContent.getSha())) {
                        throw new ServiceException.BadRequestExpception(String.format("sha in request: %s is different from sha of file %s in branch %s", sha, this.content.getPath(), this.content.getBranch()));
                    }
                    return ghContent.getSha();
                }
                catch (ServiceException.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private boolean isEmptyRepo(String apiUrl, String owner, String repoName, String accessToken) throws IOException {
        try {
            HttpRequest.head(String.format("%s/repos/%s/%s/contents", apiUrl, owner, repoName)).withAuthorization("token " + accessToken).to(String.class);
        }
        catch (ServiceException.NotFoundException e) {
            return true;
        }
        return false;
    }
}

