/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.ssh.UserSSHKeyManager;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.plugins.git.AbstractGitSCMSource;

abstract class GitReadSaveRequest {
    static final Logger log = Logger.getLogger(GitReadSaveRequest.class.getName());
    final AbstractGitSCMSource gitSource;
    final String branch;
    final String commitMessage;
    final String sourceBranch;
    final String filePath;
    final byte[] contents;

    GitReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        this.gitSource = gitSource;
        this.branch = branch;
        this.commitMessage = commitMessage;
        this.sourceBranch = sourceBranch;
        this.filePath = filePath;
        this.contents = contents == null ? null : (byte[])contents.clone();
    }

    @CheckForNull
    StandardCredentials getCredential() {
        User user;
        BasicSSHUserPrivateKey credential = null;
        if (GitUtils.isSshUrl(this.gitSource.getRemote()) || GitUtils.isLocalUnixFileUrl(this.gitSource.getRemote())) {
            user = User.current();
            if (user == null) {
                throw new ServiceException.UnauthorizedException("Not authenticated");
            }
        } else {
            throw new ServiceException.UnauthorizedException("Editing only supported for repositories using SSH");
        }
        credential = UserSSHKeyManager.getOrCreate(user);
        return credential;
    }

    abstract byte[] read() throws IOException;

    abstract void save() throws IOException;
}

