/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.User;
import hudson.tasks.MailAddressResolver;
import io.jenkins.blueocean.blueocean_git_pipeline.GitCacheCloneReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

class GitBareRepoReadSaveRequest
extends GitCacheCloneReadSaveRequest {
    private static final String LOCAL_REF_BASE = "refs/remotes/origin/";
    private static final String REMOTE_REF_BASE = "refs/heads/";

    GitBareRepoReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        super(gitSource, branch, commitMessage, sourceBranch, filePath, contents);
    }

    @Override
    byte[] read() throws IOException {
        return this.invokeOnScm(new GitSCMFileSystem.FSFunction<byte[]>(){

            public byte[] invoke(Repository repo) throws IOException, InterruptedException {
                GitUtils.validatePushAccess(repo, GitBareRepoReadSaveRequest.this.gitSource.getRemote(), GitBareRepoReadSaveRequest.this.getCredential());
                GitUtils.fetch(repo, GitBareRepoReadSaveRequest.this.getCredential());
                return GitUtils.readFile(repo, GitBareRepoReadSaveRequest.LOCAL_REF_BASE + GitBareRepoReadSaveRequest.this.branch, GitBareRepoReadSaveRequest.this.filePath);
            }
        });
    }

    @Override
    void save() throws IOException {
        this.invokeOnScm(new GitSCMFileSystem.FSFunction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(Repository repo) throws IOException, InterruptedException {
                String localBranchRef = GitBareRepoReadSaveRequest.LOCAL_REF_BASE + GitBareRepoReadSaveRequest.this.sourceBranch;
                ObjectId branchHead = repo.resolve(localBranchRef);
                try {
                    User user = User.current();
                    if (user == null) {
                        throw new ServiceException.UnauthorizedException("Not authenticated");
                    }
                    String mailAddress = MailAddressResolver.resolve((User)user);
                    StandardCredentials credential = GitBareRepoReadSaveRequest.this.getCredential();
                    GitUtils.fetch(repo, credential);
                    GitUtils.commit(repo, localBranchRef, GitBareRepoReadSaveRequest.this.filePath, GitBareRepoReadSaveRequest.this.contents, user.getId(), mailAddress, GitBareRepoReadSaveRequest.this.commitMessage, TimeZone.getDefault(), new Date());
                    GitUtils.push(GitBareRepoReadSaveRequest.this.gitSource.getRemote(), repo, credential, localBranchRef, GitBareRepoReadSaveRequest.REMOTE_REF_BASE + GitBareRepoReadSaveRequest.this.branch);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    try {
                        if (branchHead != null) {
                            RefUpdate rollback = repo.updateRef(localBranchRef);
                            rollback.setNewObjectId((AnyObjectId)branchHead);
                            rollback.forceUpdate();
                        }
                    }
                    catch (Exception ex) {
                        GitReadSaveRequest.log.log(Level.SEVERE, "Unable to roll back repo after save failure", ex);
                    }
                }
            }
        });
    }
}

