/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.ssh;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.UserRoute;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.ssh.UserKey;
import io.jenkins.blueocean.ssh.UserSSHKeyManager;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.DELETE;
import org.kohsuke.stapler.verb.GET;

@Extension
public class UserPublicKeyRoute
implements UserRoute {
    public String getUrlName() {
        return "publickey";
    }

    public Object get(BlueUser user) {
        return new Handler(user);
    }

    public static class Handler {
        final BlueUser user;

        public Handler(BlueUser user) {
            this.user = user;
        }

        @GET
        @WebMethod(name={""})
        @TreeResponse
        public UserKey getPublickey() {
            User authenticatedUser = User.current();
            if (authenticatedUser == null) {
                throw new ServiceException.UnauthorizedException("Not authorized");
            }
            if (!StringUtils.equals((String)this.user.getId(), (String)authenticatedUser.getId())) {
                throw new ServiceException.ForbiddenException("Not authorized");
            }
            UserKey publicKey = UserSSHKeyManager.getPublicKey(authenticatedUser, UserSSHKeyManager.getOrCreate(authenticatedUser));
            return publicKey;
        }

        @DELETE
        @WebMethod(name={""})
        @TreeResponse
        public UserKey resetPublicKey() {
            User authenticatedUser = User.current();
            if (authenticatedUser == null) {
                throw new ServiceException.UnauthorizedException("Not authorized");
            }
            if (!StringUtils.equals((String)this.user.getId(), (String)authenticatedUser.getId())) {
                throw new ServiceException.ForbiddenException("Not authorized");
            }
            UserSSHKeyManager.reset(authenticatedUser);
            return this.getPublickey();
        }
    }
}

