/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.PersistedList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineUpdateRequest;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitPipelineUpdateRequest
extends BluePipelineUpdateRequest {
    private final BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GitPipelineUpdateRequest(BlueScmConfig scmConfig) {
        this.scmConfig = scmConfig;
    }

    @CheckForNull
    public BluePipeline update(BluePipeline pipeline) throws IOException {
        Item item = Jenkins.getInstance().getItemByFullName(pipeline.getFullName());
        if (item instanceof MultiBranchProject) {
            Authentication a;
            ACL acl = Jenkins.getInstance().getACL();
            if (!acl.hasPermission(a = Jenkins.getAuthentication(), Item.CONFIGURE)) {
                throw new ServiceException.ForbiddenException(String.format("Failed to update Git pipeline: %s. User %s doesn't have Job configure permission", pipeline.getName(), a.getName()));
            }
            MultiBranchProject mbp = (MultiBranchProject)item;
            BranchSource branchSource = this.getGitScmSource(mbp);
            if (branchSource != null) {
                mbp.getSourcesList().replaceBy(Collections.singleton(branchSource));
                mbp.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
            }
        }
        return pipeline;
    }

    private BranchSource getGitScmSource(MultiBranchProject mbp) {
        String sourceUri = null;
        String credentialId = null;
        if (this.scmConfig != null) {
            sourceUri = this.scmConfig.getUri();
            credentialId = this.scmConfig.getCredentialId() == null ? "" : this.scmConfig.getCredentialId();
        }
        PersistedList sources = mbp.getSourcesList();
        for (BranchSource source : sources) {
            if (!(source.getSource() instanceof GitSCMSource)) continue;
            GitSCMSource gitSCMSource = (GitSCMSource)source.getSource();
            String remote = gitSCMSource.getRemote();
            if (sourceUri != null && !sourceUri.equals(gitSCMSource.getRemote())) {
                remote = sourceUri;
            }
            String cred = gitSCMSource.getCredentialsId();
            if (!gitSCMSource.getCredentialsId().equals(credentialId)) {
                cred = credentialId;
            }
            GitSCMSource s = new GitSCMSource(gitSCMSource.getId(), remote, cred, gitSCMSource.getIncludes(), gitSCMSource.getExcludes(), gitSCMSource.isIgnoreOnPushNotifications());
            s.setOwner((SCMSourceOwner)mbp);
            return new BranchSource((SCMSource)s);
        }
        if (sourceUri != null) {
            return new BranchSource((SCMSource)new GitSCMSource(null, sourceUri, credentialId, "*", "", false));
        }
        return null;
    }
}

