/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.model.Cause;
import hudson.model.TopLevelItem;
import hudson.model.User;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineCreateRequestImpl;
import java.io.IOException;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitPipelineCreateRequest
extends AbstractPipelineCreateRequestImpl {
    private static final String MODE = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    private BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GitPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        if (scmConfig == null) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline:" + name).add(new ErrorMessage.Error("scmConfig", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig is required")));
        }
        this.scmConfig = scmConfig;
    }

    public BluePipeline create(Reachable parent) throws IOException {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("Must login to create a pipeline");
        }
        String sourceUri = this.scmConfig.getUri();
        if (sourceUri == null) {
            throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Git pipeline:" + this.getName()).add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required")));
        }
        TopLevelItem item = this.create((ModifiableTopLevelItemGroup)Jenkins.getInstance(), this.getName(), MODE, MultiBranchProjectDescriptor.class);
        if (item instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject project = (WorkflowMultiBranchProject)item;
            if (StringUtils.isNotBlank((CharSequence)this.scmConfig.getCredentialId())) {
                Domain domain = CredentialsUtils.findDomain((String)this.scmConfig.getCredentialId(), (User)authenticatedUser);
                if (domain == null) {
                    throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline").add(new ErrorMessage.Error("scm.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "No domain in user credentials found for credentialId: " + this.scmConfig.getCredentialId())));
                }
                if (domain.test(new DomainRequirement[]{new BlueOceanDomainRequirement()})) {
                    project.addProperty((AbstractFolderProperty)new BlueOceanCredentialsProvider.FolderPropertyImpl(authenticatedUser.getId(), this.scmConfig.getCredentialId(), BlueOceanCredentialsProvider.createDomain((String)sourceUri)));
                }
            }
            String credentialId = StringUtils.defaultString((String)this.scmConfig.getCredentialId());
            project.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, sourceUri, credentialId, "*", "", false)));
            project.scheduleBuild((Cause)new Cause.UserIdCause());
            return new MultiBranchPipelineImpl((MultiBranchProject)project);
        }
        try {
            item.delete();
        }
        catch (InterruptedException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to delete pipeline: " + this.getName());
        }
        return null;
    }
}

