/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller.helper;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.camera.core.ImageProxy;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import com.outsystems.plugins.barcode.controller.helper.OSBARCMLKitHelperInterface;
import com.outsystems.plugins.barcode.model.OSBARCScannerHint;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelper;", "Lcom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelperInterface;", "hint", "Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;", "(Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;)V", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "getScanner", "()Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "scanner$delegate", "Lkotlin/Lazy;", "decodeImage", "", "imageProxy", "Landroidx/camera/core/ImageProxy;", "imageBitmap", "Landroid/graphics/Bitmap;", "onSuccess", "Lkotlin/Function1;", "", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "onError", "Lkotlin/Function0;", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOSBARCMLKitHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSBARCMLKitHelper.kt\ncom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class OSBARCMLKitHelper
implements OSBARCMLKitHelperInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OSBARCScannerHint hint;
    @NotNull
    private final Lazy scanner$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final String LOG_TAG = "OSBARCMLKitHelper";

    public OSBARCMLKitHelper(@Nullable OSBARCScannerHint hint) {
        this.hint = hint;
        this.scanner$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BarcodeScanner>(this){
            final /* synthetic */ OSBARCMLKitHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BarcodeScanner invoke() {
                BarcodeScannerOptions.Builder builder = new BarcodeScannerOptions.Builder();
                OSBARCMLKitHelper oSBARCMLKitHelper = this.this$0;
                BarcodeScannerOptions.Builder $this$invoke_u24lambda_u240 = builder;
                boolean bl = false;
                Integer format = OSBARCMLKitHelper.Companion.toMLKitBarcodeFormat$OSBarcodeLib_release(OSBARCMLKitHelper.access$getHint$p(oSBARCMLKitHelper));
                if (format != null) {
                    $this$invoke_u24lambda_u240.setBarcodeFormats(format.intValue(), new int[0]);
                } else {
                    $this$invoke_u24lambda_u240.enableAllPotentialBarcodes();
                }
                BarcodeScannerOptions barcodeScannerOptions = builder.build();
                Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"build(...)");
                BarcodeScannerOptions options = barcodeScannerOptions;
                return BarcodeScanning.getClient((BarcodeScannerOptions)options);
            }
        }));
    }

    private final BarcodeScanner getScanner() {
        Lazy lazy = this.scanner$delegate;
        return (BarcodeScanner)lazy.getValue();
    }

    @Override
    public void decodeImage(@NotNull ImageProxy imageProxy, @NotNull Bitmap imageBitmap, @NotNull Function1<? super List<Barcode>, Unit> onSuccess, @NotNull Function0<Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Intrinsics.checkNotNullParameter((Object)imageBitmap, (String)"imageBitmap");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        InputImage inputImage = InputImage.fromBitmap((Bitmap)imageBitmap, (int)imageProxy.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(...)");
        InputImage image = inputImage;
        this.getScanner().process(image).addOnSuccessListener(arg_0 -> OSBARCMLKitHelper.decodeImage$lambda$0((Function1)new Function1<List<Barcode>, Unit>(onSuccess){
            final /* synthetic */ Function1<List<Barcode>, Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(List<Barcode> barcodes) {
                Intrinsics.checkNotNull(barcodes);
                this.$onSuccess.invoke(barcodes);
            }
        }, arg_0)).addOnFailureListener(arg_0 -> OSBARCMLKitHelper.decodeImage$lambda$2(onError, arg_0));
    }

    private static final void decodeImage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void decodeImage$lambda$2(Function0 $onError, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$onError, (String)"$onError");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getMessage();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Log.e((String)LOG_TAG, (String)it);
        }
        $onError.invoke();
    }

    public static final /* synthetic */ OSBARCScannerHint access$getHint$p(OSBARCMLKitHelper $this) {
        return $this.hint;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u0007H\u0001\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelper$Companion;", "", "()V", "LOG_TAG", "", "toMLKitBarcodeFormat", "", "Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;", "toMLKitBarcodeFormat$OSBarcodeLib_release", "(Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;)Ljava/lang/Integer;", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final Integer toMLKitBarcodeFormat$OSBarcodeLib_release(@Nullable OSBARCScannerHint $this$toMLKitBarcodeFormat) {
            Integer n;
            OSBARCScannerHint oSBARCScannerHint = $this$toMLKitBarcodeFormat;
            switch (oSBARCScannerHint == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oSBARCScannerHint.ordinal()]) {
                case 1: {
                    n = 256;
                    break;
                }
                case 2: {
                    n = 4096;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 6: {
                    n = 1;
                    break;
                }
                case 7: {
                    n = 16;
                    break;
                }
                case 8: {
                    n = null;
                    break;
                }
                case 9: {
                    n = 128;
                    break;
                }
                case 10: {
                    n = 32;
                    break;
                }
                case 11: {
                    n = 64;
                    break;
                }
                case 12: {
                    n = 2048;
                    break;
                }
                case 13: {
                    n = null;
                    break;
                }
                case 14: {
                    n = null;
                    break;
                }
                case 15: {
                    n = 512;
                    break;
                }
                case 16: {
                    n = 1024;
                    break;
                }
                case 17: {
                    n = null;
                    break;
                }
                case 18: {
                    n = null;
                    break;
                }
                case -1: {
                    n = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OSBARCScannerHint.values().length];
                try {
                    nArray[OSBARCScannerHint.QR_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.AZTEC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.CODABAR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.CODE_39.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.CODE_93.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.CODE_128.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.DATA_MATRIX.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.MAXICODE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.ITF.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.EAN_13.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.EAN_8.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.PDF_417.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.RSS_14.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.RSS_EXPANDED.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.UPC_A.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.UPC_E.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.UPC_EAN_EXTENSION.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OSBARCScannerHint.UNKNOWN.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

