/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.Intercom;
import io.intercom.api.IntercomException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class UriBuilder {
    private StringBuilder uri;
    private TreeMap<String, String> paramsMap;

    public static UriBuilder newBuilder() {
        return new UriBuilder(Intercom.getApiBaseURI());
    }

    public static UriBuilder newBuilder(String uri) {
        return new UriBuilder(uri);
    }

    public static UriBuilder newBuilder(URI uri) {
        return new UriBuilder(uri);
    }

    private UriBuilder(String uri) {
        try {
            this.uri = new StringBuilder(new URI(uri).toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private UriBuilder(URI uri) {
        this.uri = new StringBuilder(uri.toASCIIString());
    }

    public String buildString() {
        return this.build().toASCIIString();
    }

    public URI build() {
        if (this.paramsMap != null) {
            this.uri.append("?");
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.paramsMap.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            if (sb.lastIndexOf("&") == sb.length() - 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.uri.append((CharSequence)sb);
        }
        try {
            return new URI(this.uri.toString());
        }
        catch (URISyntaxException e) {
            throw new IntercomException("could not create api url", (Throwable)e);
        }
    }

    public UriBuilder path(String path) {
        this.uri.append("/").append(this.urlEncode(path));
        return this;
    }

    public UriBuilder path(List<String> path) {
        ArrayList urlEncoded = Lists.newArrayList();
        for (String s : path) {
            urlEncoded.add(this.urlEncode(s));
        }
        this.uri.append("/").append(Joiner.on((String)"/").join((Iterable)urlEncoded));
        return this;
    }

    public UriBuilder query(String param, String value) {
        if (this.paramsMap == null) {
            this.paramsMap = Maps.newTreeMap();
        }
        this.paramsMap.put(this.urlEncode(param), this.urlEncode(value));
        return this;
    }

    public UriBuilder query(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.query(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private String urlEncode(String param) {
        try {
            return URLEncoder.encode(param, Charsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IntercomException("could not encode url param " + param, (Throwable)e);
        }
    }
}

